/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.expressions.detailcode;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

public interface IDetailExpressionProvider {
    public static final char SEPARATOR = '.';

    public List<ExpressionFeature> getInitialFeatures();

    public List<ExpressionFeature> getContextFeatures(ExpressionFeature var1);

    public static class EmptyDetailExpressionProvider
    implements IDetailExpressionProvider {
        private final List<ExpressionFeature> EMPTY_LIST = ImmutableList.of();

        @Override
        public List<ExpressionFeature> getInitialFeatures() {
            return this.EMPTY_LIST;
        }

        @Override
        public List<ExpressionFeature> getContextFeatures(ExpressionFeature ctx) {
            return this.EMPTY_LIST;
        }
    }

    @Accessors
    public static class ExpressionFeature {
        private final String id;
        private final ExpressionPostfix postfix;
        private Object data;

        public String toString() {
            String string = null;
            ExpressionPostfix postfix = this.postfix;
            if (postfix != null) {
                switch (postfix) {
                    case PARENTHESES: {
                        string = "()";
                        break;
                    }
                    case BRACKETS: {
                        string = "[]";
                        break;
                    }
                    default: {
                        string = "";
                        break;
                    }
                }
            } else {
                string = "";
            }
            String string2 = this.id + string;
            String string3 = string2 + " - ";
            Object object = null;
            object = this.data instanceof EObject ? ((EObject)this.data).eClass().getName() : this.data;
            return string3 + String.valueOf(object);
        }

        public ExpressionFeature(String id, ExpressionPostfix postfix) {
            this.id = id;
            this.postfix = postfix;
        }

        @Pure
        public String getId() {
            return this.id;
        }

        @Pure
        public ExpressionPostfix getPostfix() {
            return this.postfix;
        }

        @Pure
        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }
    }

    public static enum ExpressionPostfix {
        NONE,
        PARENTHESES,
        BRACKETS;

    }
}

