/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.abstractexec.behavior;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.eclipse.etrice.core.fsm.fSM.EntryPoint;
import org.eclipse.etrice.core.fsm.fSM.GuardedTransition;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.TransitionPoint;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.CommonTrigger;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphItem;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;

public class ReachabilityCheck {
    private GraphContainer gc;
    Queue<Node> queue = new LinkedList<Node>();
    public Set<GraphItem> visited = new HashSet<GraphItem>();
    private Set<Node> visitedSubStates = new HashSet<Node>();

    public ReachabilityCheck(GraphContainer gc) {
        this.gc = gc;
    }

    public void computeReachability() {
        this.addStartingPoints(this.gc.getGraph(), true);
        this.doTraversal();
        this.visited.addAll(this.visitedSubStates);
    }

    private void addStartingPoints(Graph graph, boolean add_initial) {
        if (add_initial) {
            for (Link link : graph.getLinks()) {
                if (!(link.getTransition() instanceof InitialTransition)) continue;
                this.visited.add((GraphItem)link);
                Node cur = link.getTarget();
                if (this.visited.contains(cur)) break;
                this.queue.add(cur);
                break;
            }
        }
    }

    private void doTraversal() {
        while (!this.queue.isEmpty()) {
            Node node = this.queue.poll();
            if (this.visited.contains(node)) continue;
            this.visit(node);
        }
    }

    public boolean isReachable(GraphItem item) {
        return this.visited.contains(item);
    }

    private void visit(Node node) {
        this.visited.add((GraphItem)node);
        if (node.getStateGraphNode() instanceof State) {
            if (node.getSubgraph() != null) {
                this.addStartingPoints(node.getSubgraph(), true);
            } else {
                for (CommonTrigger trigger : node.getCaughtTriggers()) {
                    for (Link link : trigger.getLinks()) {
                        this.visit(link);
                    }
                }
                for (Link link : FsmGenExtensions.getOutgoingLinksHierarchically((Node)node)) {
                    if (!(link.getTransition() instanceof GuardedTransition)) continue;
                    this.visit(link);
                }
            }
        } else {
            if (node.getStateGraphNode() instanceof EntryPoint) {
                Node container = FsmGenExtensions.getParentState((Node)node);
                this.visitedSubStates.add(container);
            }
            for (Link link : node.getOutgoing()) {
                this.visit(link);
            }
        }
    }

    private void visit(Link link) {
        Node source = link.getSource();
        if (source.getStateGraphNode() instanceof TransitionPoint) {
            this.visited.add((GraphItem)source);
        }
        this.visited.add((GraphItem)link);
        Node target = link.getTarget();
        if (!this.visited.contains(target)) {
            this.queue.add(target);
        }
    }
}

