/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.util.RoomSwitch;
import org.eclipse.etrice.ui.structure.support.PosAndSize;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILinkService;
import org.eclipse.graphiti.services.IPeService;

public class DiagramUtil {
    public static boolean isSupported(Object obj) {
        return obj instanceof StructureClass || obj instanceof ActorContainerRef || obj instanceof InterfaceItem || obj instanceof Binding || obj instanceof LayerConnection;
    }

    public static boolean isConnection(EObject bo) {
        return bo instanceof Binding || bo instanceof LayerConnection;
    }

    public static String getResourcePath(EObject bo) {
        assert (DiagramUtil.isSupported(bo)) : "unexpected type";
        return bo.eResource().getURI().toString() + bo.eResource().getURIFragment(bo);
    }

    public static ContainerShape findScShape(Diagram diagram) {
        ILinkService linkService = Graphiti.getLinkService();
        for (Shape child : diagram.getChildren()) {
            EObject bo = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)child);
            if (!(bo instanceof StructureClass)) continue;
            return (ContainerShape)child;
        }
        return null;
    }

    public static PosAndSize getPosAndSize(GraphicsAlgorithm ga) {
        return new PosAndSize(ga.getX(), ga.getY(), ga.getWidth(), ga.getHeight());
    }

    public static PropertyContainer findProp(List<? extends PropertyContainer> items, String key, String value) {
        IPeService peService = Graphiti.getPeService();
        for (PropertyContainer propertyContainer : items) {
            if (!value.equals(peService.getPropertyValue(propertyContainer, key))) continue;
            return propertyContainer;
        }
        return null;
    }

    public static Border getNearestBorder(PosAndSize element, PosAndSize container) {
        int left = Math.abs(element.getX());
        int right = Math.abs(container.getW() - element.getX());
        int top = Math.abs(element.getY());
        int bottom = Math.abs(container.getH() - element.getY());
        int min = left;
        Border border = Border.LEFT;
        if (right < min) {
            border = Border.RIGHT;
            min = right;
        }
        if (top < min) {
            border = Border.TOP;
            min = top;
        }
        if (bottom < min) {
            border = Border.BOTTOM;
        }
        return border;
    }

    public static Border getNearestBorder(GraphicsAlgorithm element, GraphicsAlgorithm container) {
        PosAndSize posContainer = DiagramUtil.getPosAndSize(container);
        PosAndSize pos = DiagramUtil.getPosAndSize(element);
        return DiagramUtil.getNearestBorder(pos, posContainer);
    }

    public static PosAndSize getVisibleExtent(PictogramElement pe) {
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
        if (!EObject.class.isInstance(bo)) {
            return null;
        }
        return (PosAndSize)new VisibleExtentSwitch(pe).doSwitch(bo);
    }

    public static enum Border {
        NONE,
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }

    private static class VisibleExtentSwitch
    extends RoomSwitch<PosAndSize> {
        private PictogramElement pe;

        public VisibleExtentSwitch(PictogramElement pe) {
            this.pe = pe;
        }

        public PosAndSize caseStructureClass(StructureClass object) {
            if (this.pe.getGraphicsAlgorithm() == null) {
                return null;
            }
            if (this.pe.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().size() < 2) {
                return null;
            }
            GraphicsAlgorithm visibleGa = (GraphicsAlgorithm)this.pe.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
            return DiagramUtil.getPosAndSize(visibleGa);
        }

        public PosAndSize caseInterfaceItem(InterfaceItem object) {
            if (this.pe.getGraphicsAlgorithm() == null) {
                return null;
            }
            if (this.pe.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().size() < 1) {
                return null;
            }
            GraphicsAlgorithm invisible = this.pe.getGraphicsAlgorithm();
            GraphicsAlgorithm visible = (GraphicsAlgorithm)this.pe.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0);
            return new PosAndSize(visible.getX() + invisible.getX(), visible.getY() + invisible.getY(), visible.getWidth(), visible.getHeight());
        }

        public PosAndSize caseActorContainerRef(ActorContainerRef object) {
            if (this.pe.getGraphicsAlgorithm() == null) {
                return null;
            }
            if (this.pe.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().size() < 2) {
                return null;
            }
            IPeService peService = Graphiti.getPeService();
            GraphicsAlgorithm invisible = this.pe.getGraphicsAlgorithm();
            GraphicsAlgorithm main = null;
            GraphicsAlgorithm repl = null;
            boolean isReplVisible = false;
            for (GraphicsAlgorithm ga : invisible.getGraphicsAlgorithmChildren()) {
                String value = peService.getPropertyValue((PropertyContainer)ga, "actorref_graphic_element");
                if ("mainborder".equals(value)) {
                    main = ga;
                    continue;
                }
                if (!"replborder".equals(value)) continue;
                repl = ga;
                isReplVisible = ga.getLineVisible();
            }
            if (main == null || repl == null) {
                return null;
            }
            if (isReplVisible) {
                int x = Math.min(main.getX(), repl.getX());
                int y = Math.min(main.getY(), repl.getY());
                int wTotalMain = main.getX() + main.getWidth();
                int wTotalRepl = repl.getX() + repl.getWidth();
                int hTotalMain = main.getY() + main.getHeight();
                int hTotalRepl = repl.getY() + repl.getHeight();
                return new PosAndSize(x + invisible.getX(), y + invisible.getY(), wTotalMain > wTotalRepl ? wTotalMain - x : wTotalRepl - x, hTotalMain > hTotalRepl ? hTotalMain - y : hTotalRepl - y);
            }
            return new PosAndSize(main.getX() + invisible.getX(), main.getY() + invisible.getY(), main.getWidth(), main.getHeight());
        }

        public PosAndSize defaultCase(EObject object) {
            return DiagramUtil.getPosAndSize(this.pe.getGraphicsAlgorithm());
        }
    }
}

