/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.components;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentGroup {
    public static final Set<PortSide> CONN_C = EnumSet.noneOf(PortSide.class);
    public static final Set<PortSide> CONN_W = EnumSet.of(PortSide.WEST);
    public static final Set<PortSide> CONN_E = EnumSet.of(PortSide.EAST);
    public static final Set<PortSide> CONN_N = EnumSet.of(PortSide.NORTH);
    public static final Set<PortSide> CONN_S = EnumSet.of(PortSide.SOUTH);
    public static final Set<PortSide> CONN_NS = EnumSet.of(PortSide.NORTH, PortSide.SOUTH);
    public static final Set<PortSide> CONN_WE = EnumSet.of(PortSide.EAST, PortSide.WEST);
    public static final Set<PortSide> CONN_NW = EnumSet.of(PortSide.NORTH, PortSide.WEST);
    public static final Set<PortSide> CONN_NE = EnumSet.of(PortSide.NORTH, PortSide.EAST);
    public static final Set<PortSide> CONN_SW = EnumSet.of(PortSide.SOUTH, PortSide.WEST);
    public static final Set<PortSide> CONN_SE = EnumSet.of(PortSide.SOUTH, PortSide.EAST);
    public static final Set<PortSide> CONN_NWE = EnumSet.of(PortSide.NORTH, PortSide.WEST, PortSide.EAST);
    public static final Set<PortSide> CONN_SWE = EnumSet.of(PortSide.SOUTH, PortSide.WEST, PortSide.EAST);
    public static final Set<PortSide> CONN_WNS = EnumSet.of(PortSide.WEST, PortSide.NORTH, PortSide.SOUTH);
    public static final Set<PortSide> CONN_ENS = EnumSet.of(PortSide.EAST, PortSide.NORTH, PortSide.SOUTH);
    private static final Multimap<Set<PortSide>, Set<PortSide>> CONSTRAINTS = HashMultimap.create();
    private Multimap<Set<PortSide>, LGraph> components = HashMultimap.create();

    static {
        CONSTRAINTS.put(CONN_W, CONN_WNS);
        CONSTRAINTS.put(CONN_E, CONN_ENS);
        CONSTRAINTS.put(CONN_N, CONN_NWE);
        CONSTRAINTS.put(CONN_S, CONN_SWE);
        CONSTRAINTS.put(CONN_NS, CONN_WE);
        CONSTRAINTS.put(CONN_NS, CONN_NWE);
        CONSTRAINTS.put(CONN_NS, CONN_SWE);
        CONSTRAINTS.put(CONN_WE, CONN_NS);
        CONSTRAINTS.put(CONN_WE, CONN_WNS);
        CONSTRAINTS.put(CONN_WE, CONN_ENS);
        CONSTRAINTS.put(CONN_NW, CONN_NW);
        CONSTRAINTS.put(CONN_NW, CONN_NWE);
        CONSTRAINTS.put(CONN_NW, CONN_WNS);
        CONSTRAINTS.put(CONN_NE, CONN_NE);
        CONSTRAINTS.put(CONN_NE, CONN_NWE);
        CONSTRAINTS.put(CONN_NE, CONN_ENS);
        CONSTRAINTS.put(CONN_SW, CONN_SW);
        CONSTRAINTS.put(CONN_SW, CONN_SWE);
        CONSTRAINTS.put(CONN_SW, CONN_WNS);
        CONSTRAINTS.put(CONN_SE, CONN_SE);
        CONSTRAINTS.put(CONN_SE, CONN_SWE);
        CONSTRAINTS.put(CONN_SE, CONN_ENS);
        CONSTRAINTS.put(CONN_NWE, CONN_N);
        CONSTRAINTS.put(CONN_NWE, CONN_NS);
        CONSTRAINTS.put(CONN_NWE, CONN_NW);
        CONSTRAINTS.put(CONN_NWE, CONN_NE);
        CONSTRAINTS.put(CONN_NWE, CONN_NWE);
        CONSTRAINTS.put(CONN_NWE, CONN_WNS);
        CONSTRAINTS.put(CONN_NWE, CONN_ENS);
        CONSTRAINTS.put(CONN_SWE, CONN_S);
        CONSTRAINTS.put(CONN_SWE, CONN_NS);
        CONSTRAINTS.put(CONN_SWE, CONN_SW);
        CONSTRAINTS.put(CONN_SWE, CONN_SE);
        CONSTRAINTS.put(CONN_SWE, CONN_SWE);
        CONSTRAINTS.put(CONN_SWE, CONN_WNS);
        CONSTRAINTS.put(CONN_SWE, CONN_ENS);
        CONSTRAINTS.put(CONN_WNS, CONN_W);
        CONSTRAINTS.put(CONN_WNS, CONN_WE);
        CONSTRAINTS.put(CONN_WNS, CONN_NW);
        CONSTRAINTS.put(CONN_WNS, CONN_SW);
        CONSTRAINTS.put(CONN_WNS, CONN_NWE);
        CONSTRAINTS.put(CONN_WNS, CONN_SWE);
        CONSTRAINTS.put(CONN_WNS, CONN_WNS);
        CONSTRAINTS.put(CONN_ENS, CONN_E);
        CONSTRAINTS.put(CONN_ENS, CONN_WE);
        CONSTRAINTS.put(CONN_ENS, CONN_NE);
        CONSTRAINTS.put(CONN_ENS, CONN_SE);
        CONSTRAINTS.put(CONN_ENS, CONN_NWE);
        CONSTRAINTS.put(CONN_ENS, CONN_SWE);
        CONSTRAINTS.put(CONN_ENS, CONN_ENS);
    }

    public ComponentGroup() {
    }

    public ComponentGroup(LGraph component) {
        this.add(component);
    }

    public boolean add(LGraph component) {
        if (this.canAdd(component)) {
            this.components.put((Object)((Set)component.getProperty(Properties.EXT_PORT_CONNECTIONS)), (Object)component);
            return true;
        }
        return false;
    }

    private boolean canAdd(LGraph component) {
        Set candidateSides = (Set)component.getProperty(Properties.EXT_PORT_CONNECTIONS);
        Collection constraints = CONSTRAINTS.get((Object)candidateSides);
        for (Set constraint : constraints) {
            if (this.components.get((Object)constraint).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Collection<LGraph> getComponents() {
        return this.components.values();
    }

    public Collection<LGraph> getComponents(Set<PortSide> connections) {
        return this.components.get(connections);
    }
}

