/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.klay.layered.p5edges;

import de.cau.cs.kieler.core.alg.AbstractAlgorithm;
import de.cau.cs.kieler.core.math.KielerMath;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.klay.layered.ILayoutPhase;
import de.cau.cs.kieler.klay.layered.IntermediateProcessingConfiguration;
import de.cau.cs.kieler.klay.layered.graph.LEdge;
import de.cau.cs.kieler.klay.layered.graph.LGraph;
import de.cau.cs.kieler.klay.layered.graph.LNode;
import de.cau.cs.kieler.klay.layered.graph.LPort;
import de.cau.cs.kieler.klay.layered.graph.Layer;
import de.cau.cs.kieler.klay.layered.properties.NodeType;
import de.cau.cs.kieler.klay.layered.properties.PortType;
import de.cau.cs.kieler.klay.layered.properties.Properties;

public class PolylineEdgeRouter
extends AbstractAlgorithm
implements ILayoutPhase {
    private static final double MIN_VERT_DIFF = 1.0;
    private static final double LAYER_SPACE_FAC = 0.2;

    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        return null;
    }

    public void process(LGraph layeredGraph) {
        this.getMonitor().begin("Polyline edge routing", 1.0f);
        float spacing = ((Float)layeredGraph.getProperty((IProperty)Properties.OBJ_SPACING)).floatValue();
        float edgeSpaceFac = ((Float)layeredGraph.getProperty((IProperty)Properties.EDGE_SPACING_FACTOR)).floatValue();
        double xpos = 0.0;
        double layerSpacing = 0.0;
        for (Layer layer : layeredGraph) {
            layer.placeNodes(xpos);
            double maxVertDiff = 0.0;
            for (LNode node : layer) {
                double nodeMaxOutputDiff = 0.0;
                for (LPort port : node.getPorts(PortType.OUTPUT)) {
                    double sourcePos = port.getNode().getPosition().y + port.getPosition().y + port.getAnchor().y;
                    for (LPort targetPort : port.getSuccessorPorts()) {
                        if (targetPort.getNode().getLayer() == node.getLayer()) continue;
                        double targetPos = targetPort.getNode().getPosition().y + targetPort.getPosition().y + targetPort.getAnchor().y;
                        nodeMaxOutputDiff = KielerMath.maxd((double[])new double[]{nodeMaxOutputDiff, targetPos - sourcePos, sourcePos - targetPos});
                    }
                }
                if (node.getProperty(Properties.NODE_TYPE) == NodeType.LONG_EDGE) {
                    double nodeMaxInputDiff = 0.0;
                    for (LPort port : node.getPorts(PortType.INPUT)) {
                        double targetPos = port.getNode().getPosition().y + port.getPosition().y + port.getAnchor().y;
                        for (LPort sourcePort : port.getPredecessorPorts()) {
                            double sourcePos = sourcePort.getNode().getPosition().y + sourcePort.getPosition().y + sourcePort.getAnchor().y;
                            nodeMaxInputDiff = KielerMath.maxd((double[])new double[]{nodeMaxInputDiff, targetPos - sourcePos, sourcePos - targetPos});
                        }
                    }
                    LEdge edge = (LEdge)node.getProperty(Properties.ORIGIN);
                    if (nodeMaxInputDiff >= 1.0 && nodeMaxOutputDiff >= 1.0) {
                        double layerSize = layer.getSize().x;
                        double diff = Math.max(nodeMaxInputDiff, nodeMaxOutputDiff);
                        double deviation = diff / (layerSize / 2.0 + (double)spacing + 0.2 * (double)edgeSpaceFac * diff) * layerSize / 2.0;
                        if (deviation >= (double)(edgeSpaceFac * spacing)) {
                            edge.getBendPoints().add(xpos, node.getPosition().y);
                            edge.getBendPoints().add(xpos + layerSize, node.getPosition().y);
                        } else {
                            edge.getBendPoints().add(xpos + layerSize / 2.0, node.getPosition().y);
                        }
                    } else if (nodeMaxInputDiff >= 1.0) {
                        edge.getBendPoints().add(xpos, node.getPosition().y);
                    } else if (nodeMaxOutputDiff >= 1.0) {
                        edge.getBendPoints().add(xpos + layer.getSize().x, node.getPosition().y);
                    }
                }
                maxVertDiff = Math.max(maxVertDiff, nodeMaxOutputDiff);
            }
            layerSpacing = (double)spacing + 0.2 * (double)edgeSpaceFac * maxVertDiff;
            xpos += layer.getSize().x + layerSpacing;
        }
        layeredGraph.getSize().x = xpos - layerSpacing;
        this.getMonitor().done();
    }
}

