/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.ui.views;

import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.IMutableLayoutConfig;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.ui.KimlUiPlugin;
import de.cau.cs.kieler.kiml.ui.Messages;
import de.cau.cs.kieler.kiml.ui.diagram.IDiagramLayoutManager;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutInfoService;
import de.cau.cs.kieler.kiml.ui.util.KimlUiUtil;
import de.cau.cs.kieler.kiml.ui.views.LayoutPropertySource;
import de.cau.cs.kieler.kiml.ui.views.LayoutViewPart;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;

public class DiagramDefaultAction
extends Action {
    public static final String ACTION_ID = "kieler.diagram.default";
    private static ImageDescriptor icon = KimlUiPlugin.getImageDescriptor("icons/menu16/apply2diagram.gif");
    private LayoutViewPart layoutView;

    public DiagramDefaultAction(LayoutViewPart thelayoutView, String text) {
        super(text, icon);
        this.layoutView = thelayoutView;
    }

    public void run() {
        IWorkbenchPart workbenchPart = this.layoutView.getCurrentWorkbenchPart();
        IDiagramLayoutManager<?> manager = EclipseLayoutInfoService.getInstance().getManager(workbenchPart, null);
        if (manager != null) {
            Object diagramPart = manager.getAdapter(workbenchPart, manager.getAdapterList()[0]);
            IMutableLayoutConfig layoutConfig = (IMutableLayoutConfig)manager.getAdapter(null, IMutableLayoutConfig.class);
            EditingDomain editingDomain = (EditingDomain)manager.getAdapter(workbenchPart, EditingDomain.class);
            if (diagramPart != null && layoutConfig != null && editingDomain != null) {
                LayoutContext context = new LayoutContext();
                context.setProperty(LayoutContext.DIAGRAM_PART, diagramPart);
                context.setProperty(IMutableLayoutConfig.OPT_RECURSIVE, (Object)true);
                layoutConfig.enrich(context);
                for (IPropertySheetEntry entry : this.layoutView.getSelection()) {
                    this.applyOption(editingDomain, layoutConfig, context, entry);
                }
            }
        }
    }

    private void applyOption(EditingDomain editingDomain, final IMutableLayoutConfig config, final LayoutContext context, IPropertySheetEntry entry) {
        final LayoutOptionData<?> optionData = KimlUiUtil.getOptionData(this.layoutView.getCurrentLayouterData(), entry.getDisplayName());
        if (optionData == null) {
            return;
        }
        final Object value = optionData.equals((Object)LayoutOptions.ALGORITHM) ? LayoutPropertySource.getLayoutHint(entry.getValueAsString()) : optionData.parseValue(entry.getValueAsString());
        if (value != null) {
            Runnable modelChange = new Runnable(){

                public void run() {
                    config.setValue(optionData, context, value);
                }
            };
            KimlUiUtil.runModelChange(modelChange, (TransactionalEditingDomain)editingDomain, Messages.getString("kiml.ui.13"));
        }
    }
}

