/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service.grana.analyses;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.math.KielerMath;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.service.grana.AnalysisOptions;
import de.cau.cs.kieler.kiml.service.grana.IAnalysis;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeCrossingsAnalysis
implements IAnalysis {
    public static final String ID = "de.cau.cs.kieler.kiml.grana.edgeCrossings";

    private static boolean hasIntersection(KVector p1, KVector p2, KVector q1, KVector q2) {
        double s = (q2.y - q1.y) * (p2.x - p1.x) - (q2.x - q1.x) * (p2.y - p1.y);
        if (s == 0.0) {
            return false;
        }
        double a1 = (q2.x - q1.x) * (p1.y - q1.y) - (q2.y - q1.y) * (p1.x - q1.x);
        double a2 = (p2.x - p1.x) * (p1.y - q1.y) - (p2.y - p1.y) * (p1.x - q1.x);
        double t1 = a1 / s;
        double t2 = a2 / s;
        return 0.0 < t1 && t1 < 1.0 && 0.0 < t2 && t2 < 1.0;
    }

    private static int computeNumberOfCrossings(KVectorChain chain1, KVectorChain chain2) {
        int numberOfCrossings = 0;
        Iterator points1 = chain1.iterator();
        KVector p1 = (KVector)points1.next();
        while (points1.hasNext()) {
            KVector p2 = (KVector)points1.next();
            numberOfCrossings += EdgeCrossingsAnalysis.computeNumberOfCrossings(p1, p2, chain2);
            p1 = p2;
        }
        return numberOfCrossings;
    }

    private static int computeNumberOfCrossings(KVector p1, KVector p2, KVectorChain chain2) {
        int numberOfCrossings = 0;
        Iterator points2 = chain2.iterator();
        KVector q1 = (KVector)points2.next();
        while (points2.hasNext()) {
            KVector q2 = (KVector)points2.next();
            numberOfCrossings += EdgeCrossingsAnalysis.hasIntersection(p1, p2, q1, q2) ? 1 : 0;
            q1 = q2;
        }
        return numberOfCrossings;
    }

    @Override
    public Object doAnalysis(KNode parentNode, Map<String, Object> results, IKielerProgressMonitor progressMonitor) {
        progressMonitor.begin("Edge Crossings analysis", 1.0f);
        boolean hierarchy = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(AnalysisOptions.ANALYZE_HIERARCHY);
        LinkedList nodeQueue = new LinkedList();
        ArrayList<KEdge> edges = new ArrayList<KEdge>();
        ArrayList<KVectorChain> chains = new ArrayList<KVectorChain>();
        nodeQueue.addAll(parentNode.getChildren());
        while (!nodeQueue.isEmpty()) {
            KNode node = (KNode)nodeQueue.poll();
            for (KEdge edge : node.getOutgoingEdges()) {
                if (!hierarchy && edge.getTarget().getParent() != parentNode) continue;
                KVectorChain chain = ((KEdgeLayout)edge.getData(KEdgeLayout.class)).createVectorChain();
                KNode parent = node;
                if (!KimlUtil.isDescendant((KNode)edge.getTarget(), (KNode)parent)) {
                    parent = node.getParent();
                }
                KVector referencePoint = new KVector();
                KimlUtil.toAbsolute((KVector)referencePoint, (KNode)parent);
                chain.translate(referencePoint);
                if (((KEdgeLayout)edge.getData(KEdgeLayout.class)).getProperty(LayoutOptions.EDGE_ROUTING) == EdgeRouting.SPLINES) {
                    chain = KielerMath.approximateSpline((KVectorChain)chain);
                }
                edges.add(edge);
                chains.add(chain);
            }
            if (!hierarchy) continue;
            nodeQueue.addAll(node.getChildren());
        }
        int edgeCount = edges.size();
        int[] crossings = new int[edgeCount];
        int i = 0;
        while (i < edgeCount) {
            KEdge edge1 = (KEdge)edges.get(i);
            KVectorChain chain1 = (KVectorChain)chains.get(i);
            KNode source1 = edge1.getSource();
            KNode target1 = edge1.getTarget();
            KPort sourcePort1 = edge1.getSourcePort();
            KPort targetPort1 = edge1.getTargetPort();
            KShapeLayout sourceLayout1 = (KShapeLayout)source1.getData(KShapeLayout.class);
            KShapeLayout targetLayout1 = (KShapeLayout)target1.getData(KShapeLayout.class);
            int j = i + 1;
            while (j < edgeCount) {
                KEdge edge2 = (KEdge)edges.get(j);
                KNode source2 = edge2.getSource();
                KNode target2 = edge2.getTarget();
                KPort sourcePort2 = edge2.getSourcePort();
                KPort targetPort2 = edge2.getTargetPort();
                boolean samePort = false;
                samePort |= sourcePort1 != null && (sourcePort1 == sourcePort2 || sourcePort1 == targetPort2);
                samePort |= targetPort1 != null && (targetPort1 == targetPort2 || targetPort1 == sourcePort2);
                samePort |= (Boolean)sourceLayout1.getProperty(LayoutOptions.HYPERNODE) != false && (source1 == source2 || source1 == target2);
                if (!(samePort |= (Boolean)targetLayout1.getProperty(LayoutOptions.HYPERNODE) != false && (target1 == target2 || target1 == source2))) {
                    KVectorChain chain2 = (KVectorChain)chains.get(j);
                    int c = EdgeCrossingsAnalysis.computeNumberOfCrossings(chain1, chain2);
                    int n = i;
                    crossings[n] = crossings[n] + c;
                    int n2 = j;
                    crossings[n2] = crossings[n2] + c;
                }
                ++j;
            }
            ++i;
        }
        int min = Integer.MAX_VALUE;
        int max = 0;
        int sum = 0;
        float avg = 0.0f;
        int i2 = 0;
        while (i2 < edgeCount) {
            sum += crossings[i2];
            min = Math.min(min, crossings[i2]);
            max = Math.max(max, crossings[i2]);
            ++i2;
        }
        if (edgeCount > 0) {
            avg = (float)sum / (float)edgeCount;
        } else {
            min = 0;
        }
        progressMonitor.done();
        return new Object[]{min, Float.valueOf(avg), max, sum /= 2};
    }
}

