/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.kairos.timesquare.statespace.view.views;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import fr.inria.kairos.timesquare.grph.viewer.GrphView;
import fr.inria.kairos.timesquare.grph.viewer.GrphViewControler;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import javafx.embed.swt.FXCanvas;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.inject.Inject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.part.ViewPart;

public class MoCCMLStateSpaceView
extends ViewPart {
    public static final String ID = "fr.inria.kairos.timesquare.statespace.view.views.MoCCMLStateSpaceView";
    @Inject
    IWorkbench workbench;
    private static MoCCMLStateSpaceView courant = null;
    GrphView view;
    public GrphViewControler controller;
    private FXCanvas fxCanvas;

    public MoCCMLStateSpaceView() {
        MoCCMLStateSpaceView.setCourant(this);
    }

    public static synchronized MoCCMLStateSpaceView getCourant() {
        if (courant == null) {
            try {
                PluginHelpers.getShowView((String)ID);
                if (courant == null) {
                    PluginHelpers.getCreateView((String)ID);
                }
                PluginHelpers.getShowView((String)ID);
                if (courant != null) {
                    courant.setFocus();
                }
            }
            catch (Throwable ex) {
                ErrorConsole.printError((Throwable)ex, (String)"problem initializing moccml state space view");
            }
        }
        return courant;
    }

    public void dispose() {
        super.dispose();
        MoCCMLStateSpaceView.setCourant(null);
    }

    private static final synchronized void setCourant(MoCCMLStateSpaceView courant) {
        MoCCMLStateSpaceView.courant = courant;
    }

    public void createPartControl(final Composite parent) {
        this.fxCanvas = new FXCanvas(parent, 0);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MoCCMLStateSpaceView.this.view = new GrphView();
                MoCCMLStateSpaceView.this.controller = new GrphViewControler(MoCCMLStateSpaceView.this.view);
                BorderPane root = new BorderPane();
                int width = parent.getSize().x;
                int height = parent.getSize().y;
                Scene scene = new Scene((Parent)root, (double)width, (double)height, (Paint)Color.WHITE);
                MoCCMLStateSpaceView.this.view.internalView.modifyWidth((double)(width - 10));
                MoCCMLStateSpaceView.this.view.internalView.modifyHeight((double)(height + 10));
                root.getChildren().add((Object)MoCCMLStateSpaceView.this.view.internalView);
                MoCCMLStateSpaceView.this.fxCanvas.setScene(scene);
                root.setOnKeyTyped((EventHandler)new EventHandler<Event>(){

                    public void handle(Event event) {
                        if (event instanceof KeyEvent) {
                            if (((KeyEvent)event).getCode() == KeyCode.C || ((KeyEvent)event).getCharacter().compareTo("c") == 0) {
                                (this).MoCCMLStateSpaceView.this.controller.highlightNextSchedule();
                                return;
                            }
                            if (((KeyEvent)event).getCode() == KeyCode.P || ((KeyEvent)event).getCharacter().compareTo("p") == 0) {
                                (this).MoCCMLStateSpaceView.this.controller.clearAllInitPath();
                                (this).MoCCMLStateSpaceView.this.controller.highlightNextSchedule();
                                return;
                            }
                            System.out.println("skip cycle with Levenshtein distance lower than " + Integer.parseInt(((KeyEvent)event).getCharacter()));
                            (this).MoCCMLStateSpaceView.this.controller.highlightNextDifferentSchedule(Integer.parseInt(((KeyEvent)event).getCharacter()));
                        }
                    }
                });
                root.setOnContextMenuRequested((EventHandler)new EventHandler<Event>(){

                    public void handle(Event event) {
                        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                        int width = parent.getSize().x;
                        int height = parent.getSize().y;
                        (this).MoCCMLStateSpaceView.this.view.internalView.modifyWidth((double)(width - 10));
                        (this).MoCCMLStateSpaceView.this.view.internalView.modifyHeight((double)(height - 10));
                    }
                });
            }
        });
    }

    private void addGrph(final int initialState) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MoCCMLStateSpaceView.this.controller.addGrph(initialState);
            }
        });
    }

    public void setFocus() {
        this.fxCanvas.setFocus();
    }
}

