/*
 * Decompiled with CFR 0.152.
 */
package com.sun.connector.jaxr;

import com.sun.connector.jaxr.JaxrConnectionManager;
import com.sun.connector.jaxr.JaxrConnectionRequestInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.xml.registry.Connection;
import javax.xml.registry.ConnectionFactory;
import javax.xml.registry.FederatedConnection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnsupportedCapabilityException;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;

public class JaxrConnectionFactory
extends ConnectionFactory
implements Serializable,
Referenceable {
    private ManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Reference reference;
    private Properties properties;
    @LogMessagesResourceBundle
    private static final Logger log = Logger.getLogger("com.sun.connector.jaxr");

    public JaxrConnectionFactory(ManagedConnectionFactory paramManagedConnectionFactory, ConnectionManager paramConnectionManager) {
        this.mcf = paramManagedConnectionFactory;
        log.fine("JAXRConnectionFactory constructor - ManagedConnectionFactory and ConnectionManager are parameters");
        this.cm = new JaxrConnectionManager();
    }

    public Connection getConnection() throws JAXRException {
        try {
            JaxrConnectionRequestInfo localJaxrConnectionRequestInfo = null;
            if (this.properties != null) {
                localJaxrConnectionRequestInfo = new JaxrConnectionRequestInfo(this.properties);
            }
            log.fine("JAXRConnectionFactory getConnection - ConnectionManager calling allocateConnection");
            return (Connection)this.cm.allocateConnection(this.mcf, (ConnectionRequestInfo)localJaxrConnectionRequestInfo);
        }
        catch (ResourceException localResourceException) {
            throw new JAXRException(localResourceException.getMessage());
        }
    }

    public Connection getConnection(String paramString1, String paramString2) throws JAXRException {
        throw new JAXRException(ResourceBundle.getBundle("com/sun/connector/jaxr/LocalStrings").getString("Getting_a_connection_with_username,_password_parameters_is_not_supported"));
    }

    Connection getConnection(Properties paramProperties) throws JAXRException {
        try {
            JaxrConnectionRequestInfo localJaxrConnectionRequestInfo = new JaxrConnectionRequestInfo(paramProperties);
            return (Connection)this.cm.allocateConnection(this.mcf, (ConnectionRequestInfo)localJaxrConnectionRequestInfo);
        }
        catch (ResourceException localResourceException) {
            throw new JAXRException(localResourceException.getMessage());
        }
    }

    public void setProperties(Properties paramProperties) throws JAXRException {
        this.properties = paramProperties;
    }

    public Properties getProperties() throws JAXRException {
        return this.properties;
    }

    public Connection createConnection() throws JAXRException {
        log.fine("JAXRConnectionFactory createConnection calling getConnection -");
        return this.getConnection();
    }

    public FederatedConnection createFederatedConnection(Collection paramCollection) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public void setReference(Reference paramReference) {
        this.reference = paramReference;
    }

    public Reference getReference() {
        return this.reference;
    }
}

