/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.jboss.logging.Logger;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveHandler;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.environment.util.Files;

public class FileSystemBeanArchiveHandler
implements BeanArchiveHandler {
    private static final Logger log = Logger.getLogger(FileSystemBeanArchiveHandler.class);
    public static final String CLASS_FILE_EXTENSION = ".class";

    @Override
    public BeanArchiveBuilder handle(String path) {
        File file;
        boolean nested = false;
        if (path.contains("!/")) {
            file = new File(path.substring(0, path.indexOf("!/")));
            nested = true;
        } else {
            file = new File(path);
        }
        if (!file.canRead()) {
            return null;
        }
        BeanArchiveBuilder builder = new BeanArchiveBuilder();
        try {
            log.debugv("Handle path: {0}", (Object)path);
            if (file.isDirectory()) {
                this.handleDirectory(new DirectoryEntry().setFile(file), builder);
            } else if (nested) {
                this.handleNestedFile(path, file, builder);
            } else {
                this.handleFile(file, builder);
            }
        }
        catch (Exception e) {
            CommonLogger.LOG.cannotHandleFilePath(file, path, e);
            return null;
        }
        return builder;
    }

    protected void handleFile(File file, BeanArchiveBuilder builder) throws IOException {
        log.debugv("Handle archive file: {0}", (Object)file);
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            ZipFileEntry entry = new ZipFileEntry("jar:" + file.toURI().toURL().toExternalForm() + "!/");
            while (entries.hasMoreElements()) {
                this.add(entry.setName(entries.nextElement().getName()), builder);
            }
        }
    }

    protected void handleDirectory(DirectoryEntry entry, BeanArchiveBuilder builder) throws IOException {
        log.debugv("Handle directory: {0}", (Object)entry.getFile());
        File[] files = entry.getFile().listFiles();
        String parentPath = entry.getName();
        for (File child : files) {
            if (entry.getName() != null) {
                entry.setPath(entry.getName() + "/" + child.getName());
            } else {
                entry.setPath(child.getName());
            }
            entry.setFile(child);
            if (child.isDirectory()) {
                this.handleDirectory(entry, builder);
            } else {
                this.add(entry, builder);
            }
            entry.setPath(parentPath);
        }
    }

    protected void handleNestedFile(String path, File file, BeanArchiveBuilder builder) throws IOException {
        log.debugv("Handle nested archive\n  File: {0}\n  Path: {1}", (Object)file, (Object)path);
        String nestedEntryName = path.substring(path.indexOf("!/") + "!/".length(), path.length());
        if (nestedEntryName.contains("!/")) {
            throw new IllegalArgumentException("Recursive nested archives are not supported");
        }
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.getName().equals(nestedEntryName)) {
                    ZipFileEntry entry = this.getZipFileEntry(file, zipEntry);
                    ZipInputStream nestedZip = new ZipInputStream(zip.getInputStream(zipEntry));
                    Throwable throwable = null;
                    try {
                        ZipEntry nestedEntry;
                        while ((nestedEntry = nestedZip.getNextEntry()) != null) {
                            this.add(entry.setName(nestedEntry.getName()), builder);
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (nestedZip == null) continue;
                        if (throwable != null) {
                            try {
                                nestedZip.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        nestedZip.close();
                        continue;
                    }
                }
                if (!zipEntry.getName().startsWith(nestedEntryName)) continue;
                this.add(this.getZipFileEntry(file, zipEntry).setName(zipEntry.getName().substring(nestedEntryName.length() + 1)), builder);
            }
        }
    }

    private ZipFileEntry getZipFileEntry(File file, ZipEntry zipEntry) throws MalformedURLException {
        return new ZipFileEntry("jar:" + file.toURI().toURL().toExternalForm() + "!/" + zipEntry.getName());
    }

    protected void add(Entry entry, BeanArchiveBuilder builder) throws MalformedURLException {
        if (Files.isClass(entry.getName())) {
            builder.addClass(Files.filenameToClassname(entry.getName()));
        }
    }

    private static class DirectoryEntry
    implements Entry {
        private String path;
        private File file;

        private DirectoryEntry() {
        }

        @Override
        public String getName() {
            return this.path;
        }

        @Override
        public URL getUrl() throws MalformedURLException {
            return this.file.toURI().toURL();
        }

        public DirectoryEntry setPath(String path) {
            this.path = path;
            return this;
        }

        public File getFile() {
            return this.file;
        }

        public DirectoryEntry setFile(File dir) {
            this.file = dir;
            return this;
        }
    }

    private static class ZipFileEntry
    implements Entry {
        private String name;
        private String archiveUrl;

        ZipFileEntry(String archiveUrl) {
            this.archiveUrl = archiveUrl;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public URL getUrl() throws MalformedURLException {
            return new URL(this.archiveUrl + this.name);
        }

        ZipFileEntry setName(String name) {
            this.name = name;
            return this;
        }
    }

    protected static interface Entry {
        public String getName();

        public URL getUrl() throws MalformedURLException;
    }
}

