/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Button;
import com.sun.webui.jsf.component.IFrame;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.component.VersionPage;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class VersionPageRenderer
extends AbstractRenderer {
    private static final String DEFAULT_VERSIONINFO_HEIGHT = "330";

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        String versionBodyStyle;
        String styleClass;
        if (context == null || component == null || writer == null) {
            throw new NullPointerException();
        }
        VersionPage versionPage = (VersionPage)component;
        Theme theme = ThemeUtilities.getTheme(context);
        String style = versionPage.getStyle();
        writer.startElement("div", (UIComponent)versionPage);
        writer.writeAttribute("id", (Object)versionPage.getClientId(context), "id");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if ((styleClass = RenderingUtilities.getStyleClasses(context, component, versionBodyStyle = theme.getStyleClass("VERSION_BODY"))) != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        this.renderVersionMasthead(context, versionPage, writer, theme);
        style = theme.getStyleClass("VERSION_MARGIN");
        writer.startElement("div", (UIComponent)versionPage);
        writer.writeAttribute("class", (Object)style, null);
        this.renderVersionInformation(context, versionPage, writer, theme);
        writer.endElement("div");
        this.renderCloseButton(context, versionPage, writer, theme);
        writer.endElement("div");
    }

    protected void renderVersionMasthead(FacesContext context, VersionPage versionPage, ResponseWriter writer, Theme theme) throws IOException {
        UIComponent mhFacet = versionPage.getFacet("identityContent");
        if (mhFacet != null) {
            RenderingUtilities.renderComponent(mhFacet, context);
        } else {
            this.renderVersionMastheadImages(context, versionPage, theme, writer);
        }
    }

    protected void renderVersionMastheadImages(FacesContext context, VersionPage versionPage, Icon corplogo, ResponseWriter writer, Theme theme) throws IOException {
        this.renderVersionMastheadImages(context, versionPage, theme, writer);
    }

    protected void renderVersionMastheadImages(FacesContext context, VersionPage versionPage, Theme theme, ResponseWriter writer) throws IOException {
        String style = theme.getStyleClass("VERSION_MASTHEAD_BODY");
        writer.startElement("div", (UIComponent)versionPage);
        writer.writeAttribute("class", (Object)style, null);
        writer.writeText((Object)"\n", null);
        style = theme.getStyleClass("VERSION_PRODUCT_TD");
        writer.startElement("div", (UIComponent)versionPage);
        writer.writeAttribute("class", (Object)style, null);
        style = theme.getStyleClass("VERSION_PRODUCT_DIV");
        writer.startElement("div", (UIComponent)versionPage);
        writer.writeAttribute("class", (Object)style, null);
        String id = versionPage.getId();
        boolean size = false;
        Object altText = null;
        UIComponent image = this.getProductImage(context, versionPage, theme);
        if (image != null) {
            RenderingUtilities.renderComponent(image, context);
        }
        writer.endElement("div");
        writer.endElement("div");
        image = this.getCorporateLogo(context, versionPage, theme);
        if (image != null) {
            style = theme.getStyleClass("VERSION_LOGO_TD");
            writer.startElement("div", (UIComponent)versionPage);
            writer.writeAttribute("class", (Object)style, null);
            style = theme.getStyleClass("VERSION_LOGO_DIV");
            writer.startElement("div", (UIComponent)versionPage);
            writer.writeAttribute("class", (Object)style, null);
            RenderingUtilities.renderComponent(image, context);
            writer.endElement("div");
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    protected void renderVersionInformation(FacesContext context, VersionPage versionPage, ResponseWriter writer, Theme theme) throws IOException {
        String file = versionPage.getVersionInformationFile();
        if (file != null) {
            this.renderVersionInformationFile(context, versionPage, writer);
        } else {
            this.renderVersionInformationInline(context, versionPage, writer, theme);
        }
    }

    protected void renderVersionInformationFile(FacesContext context, VersionPage versionPage, ResponseWriter writer) throws IOException {
        IFrame iframe = new IFrame();
        iframe.setId(versionPage.getId() + "_versionInformationIFrame");
        iframe.setAlign("left");
        iframe.setHeight(DEFAULT_VERSIONINFO_HEIGHT);
        iframe.setWidth("100%");
        iframe.setScrolling("auto");
        iframe.setUrl(versionPage.getVersionInformationFile());
        RenderingUtilities.renderComponent((UIComponent)iframe, context);
    }

    protected void renderVersionInformationInline(FacesContext context, VersionPage versionPage, ResponseWriter writer, Theme theme) throws IOException {
        String text = null;
        String style = theme.getStyleClass("VERSION_HEADER_TEXT");
        writer.startElement("div", (UIComponent)versionPage);
        writer.writeAttribute("class", (Object)style, null);
        text = versionPage.getVersionString();
        if (text != null) {
            writer.writeText((Object)text, "versionString");
        }
        writer.endElement("div");
        style = theme.getStyleClass("VERSION_TEXT");
        writer.startElement("div", (UIComponent)versionPage);
        writer.writeAttribute("class", (Object)style, null);
        text = versionPage.getCopyrightString();
        if (text != null) {
            writer.write(text);
        }
        writer.endElement("div");
    }

    protected void renderCloseButton(FacesContext context, VersionPage versionPage, ResponseWriter writer, Theme theme) throws IOException {
        Button button = new Button();
        button.setId(versionPage.getId() + "_versionPageCloseButton");
        button.setText(ThemeUtilities.getTheme(context).getMessage("Version.closeButton"));
        button.setPrimary(true);
        button.setOnClick("javascript: parent.close(); return false;");
        String style = theme.getStyleClass("VERSION_BUTTON_MARGIN_DIV");
        writer.startElement("div", (UIComponent)versionPage);
        writer.writeAttribute("class", (Object)style, null);
        RenderingUtilities.renderComponent((UIComponent)button, context);
        writer.endElement("div");
        writer.startElement("script", (UIComponent)versionPage);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("document.forms[0]." + button.getClientId(context) + ".focus()");
        writer.endElement("script");
    }

    protected UIComponent getCorporateLogo(FacesContext context, VersionPage versionPage, Theme theme) {
        Icon corpLogo = null;
        try {
            String imagePath = theme.getImagePath("VERSION_CORPLOGO");
            if (imagePath == null) {
                return null;
            }
            corpLogo = ThemeUtilities.getIcon(theme, "VERSION_CORPLOGO");
            if (corpLogo != null) {
                corpLogo.setId(versionPage.getId() + "_versionPageJavaLogo");
                corpLogo.setParent((UIComponent)versionPage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return corpLogo;
    }

    protected UIComponent getProductImage(FacesContext context, VersionPage versionPage, Theme theme) {
        int dim;
        String imageAttr = versionPage.getProductImageURL();
        if (imageAttr == null || imageAttr.trim().length() == 0) {
            return null;
        }
        ImageComponent image = new ImageComponent();
        image.setId(versionPage.getId() + "_versionPageProductImage");
        image.setUrl(imageAttr);
        imageAttr = versionPage.getProductImageDescription();
        if (imageAttr != null && imageAttr.trim().length() != 0) {
            image.setAlt(imageAttr);
        }
        if ((dim = versionPage.getProductImageHeight()) > 0) {
            image.setHeight(dim);
        }
        if ((dim = versionPage.getProductImageWidth()) > 0) {
            image.setWidth(dim);
        }
        image.setBorder(0);
        return image;
    }
}

