/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.api.NoPersistPartitionedStoreImpl;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.plugin.spi.SubscriptionSpi;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConflictException;
import com.sun.messaging.jmq.jmsserver.util.ConsumerAlreadyAddedException;
import com.sun.messaging.jmq.jmsserver.util.PartitionNotFoundException;
import com.sun.messaging.jmq.util.CacheHashMap;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.lists.SubSet;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Subscription
extends Consumer
implements SubscriptionSpi {
    static final long serialVersionUID = -6794838710921895217L;
    private static boolean DEBUG = false;
    private static CacheHashMap cache = new CacheHashMap(20);
    static Map<String, Subscription> durableList = new LinkedHashMap<String, Subscription>();
    static Map nonDurableList = new HashMap();
    boolean isDurable = true;
    boolean jmsshared = false;
    transient String ndSubscriptionName = null;
    transient Map activeConsumers = null;
    transient boolean stored = false;
    SubSet msgsSubset = null;
    int maxNumActiveConsumers = 1;
    transient Object subLock = new Object();
    protected String durableName = null;
    protected String clientID = null;
    int hashcode = 0;
    private transient Map<Integer, ChangeRecordInfo> currentChangeRecordInfo = Collections.synchronizedMap(new HashMap());
    private transient FaultInjection fi = FaultInjection.getInjection();
    private static boolean loaded;

    public ChangeRecordInfo getCurrentChangeRecordInfo(int type) {
        return this.currentChangeRecordInfo.get(type);
    }

    public void setCurrentChangeRecordInfo(int type, ChangeRecordInfo cri) {
        this.currentChangeRecordInfo.put(type, cri);
    }

    public boolean isDurable() {
        return this.isDurable;
    }

    @Override
    public int numInProcessMsgs() {
        int queued = this.msgs.size();
        return queued += this.numPendingAcks();
    }

    @Override
    public int numPendingAcks() {
        int pendingcnt = 0;
        List l = this.getChildConsumers();
        for (Consumer c : l) {
            pendingcnt += c.numPendingAcks();
        }
        return pendingcnt;
    }

    public List getChildConsumers() {
        if (this.activeConsumers == null) {
            return new ArrayList();
        }
        return new ArrayList(this.activeConsumers.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hashtable getDebugState() {
        Hashtable ht = super.getDebugState();
        ht.put("type", "SUBSCRIPTION");
        if (this.durableName != null) {
            ht.put("durableName", this.durableName);
        } else {
            ht.put("durableName", "<none - shared non-durable>");
        }
        ht.put("isDurable", String.valueOf(this.isDurable));
        ht.put("clientID", this.clientID == null ? "" : this.clientID);
        ht.put("stored", String.valueOf(this.stored));
        ht.put("maxNumActiveConsumers", String.valueOf(this.maxNumActiveConsumers));
        ht.put("valid", String.valueOf(this.valid));
        ht.put("activeConsumersSize", String.valueOf(this.activeConsumers.size()));
        Vector<String> v = new Vector<String>();
        Map map = this.activeConsumers;
        synchronized (map) {
            Iterator itr = this.activeConsumers.keySet().iterator();
            while (itr.hasNext()) {
                v.add(String.valueOf(((ConsumerUID)itr.next()).longValue()));
            }
        }
        ht.put("activeConsumers", v);
        return ht;
    }

    public int getActiveSubscriberCnt() {
        return this.activeConsumers.size();
    }

    @Deprecated
    public void setConsumerUID(ConsumerUID uid) {
        this.uid = uid;
    }

    public boolean equals(Object o) {
        if (o instanceof Subscription) {
            Subscription sub = (Subscription)o;
            if (this.isDurable != sub.isDurable) {
                return false;
            }
            if (Subscription.test2ObjectNotEqual(this.ndSubscriptionName, sub.ndSubscriptionName)) {
                return false;
            }
            if (this.isDurable) {
                return this.durableName.equals(sub.durableName) && !Subscription.test2ObjectNotEqual(this.clientID, sub.clientID);
            }
            if (this.ndSubscriptionName != null) {
                return this.ndSubscriptionName.equals(sub.ndSubscriptionName) && !Subscription.test2ObjectNotEqual(this.clientID, sub.clientID);
            }
            return !Subscription.test2ObjectNotEqual(this.clientID, sub.clientID) && !Subscription.test2ObjectNotEqual(this.dest, sub.dest) && !Subscription.test2ObjectNotEqual(this.selstr, sub.selstr);
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.currentChangeRecordInfo = Collections.synchronizedMap(new HashMap());
        this.activeConsumers = new HashMap();
        this.subLock = new Object();
        this.stored = true;
        this.active = false;
        this.ndSubscriptionName = null;
        this.getConsumerUID().setShouldStore(true);
        this.hashcode = this.calcHashcode();
        this.ackMsgsOnDestroy = true;
        this.fi = FaultInjection.getInjection();
    }

    private int calcHashcode() {
        if (this.isDurable) {
            return this.durableName.hashCode() * 31 + (this.clientID == null ? 0 : this.clientID.hashCode());
        }
        if (this.ndSubscriptionName != null) {
            return this.ndSubscriptionName.hashCode() * 31 + (this.clientID == null ? 0 : this.clientID.hashCode());
        }
        return this.dest.hashCode() * 31 + (this.clientID == null ? 0 : this.clientID.hashCode()) + 961 * (this.selstr == null ? 0 : this.selstr.hashCode());
    }

    private Subscription(DestinationUID d, String selector, boolean noLocal, String durable, boolean share, boolean jmsshare, String clientID, boolean notify, boolean autostore, ConsumerUID requid, Integer sharecnt) throws IOException, SelectorFormatException, BrokerException {
        super(d, selector, noLocal, requid);
        if (DEBUG || this.logger.getLevel() <= 4) {
            this.logger.log(8, "Creating Subscription(duid=" + d + ", selector" + selector + ", noLocal=" + noLocal + ", durable=" + durable + ", share=" + share + ", jmsshare=" + jmsshare + ", clientID=" + clientID + ", notify=" + notify + ", autostore=" + autostore + ", requid" + requid + ", sharecnt=" + sharecnt + "), uid=" + this.uid + ", " + Subscription.getDSubLogString(clientID, this.durableName));
        }
        this.getConsumerUID().setShouldStore(true);
        this.durableName = durable;
        if (share) {
            if (sharecnt == null) {
                this.setShared(true);
            } else {
                this.setMaxNumActiveConsumers(sharecnt);
            }
        }
        this.jmsshared = jmsshare;
        this.clientID = clientID;
        this.activeConsumers = new HashMap();
        this.active = false;
        this.hashcode = this.calcHashcode();
        this.ackMsgsOnDestroy = true;
        if (notify) {
            Globals.getClusterBroadcast().recordCreateSubscription(this);
        } else if (Globals.getHAEnabled() && Globals.getStore().isJDBCStore()) {
            autostore = notify;
            this.stored = notify;
        }
        try {
            if (autostore) {
                if (this.fi.FAULT_INJECTION) {
                    this.fi.checkFaultAndThrowBrokerException("dura.store.1", null);
                }
                Globals.getStore().storeInterest(this, Destination.PERSIST_SYNC);
                this.stored = true;
            }
        }
        catch (Exception ex) {
            Object[] args = new String[]{this.getDSubLongLogString(), d.toString()};
            if (ex instanceof ConsumerAlreadyAddedException) {
                this.logger.log(8, this.br.getKString("B3147", args) + ": " + ex.getMessage());
            }
            this.logger.logStack(32, "B3147", args, (Throwable)ex);
            if (notify) {
                try {
                    Globals.getClusterBroadcast().recordUnsubscribe(this);
                }
                catch (Exception e) {
                    this.logger.logStack(32, this.br.getKString("B4407", Subscription.getDSubLogString(clientID, durable), e.getMessage()), (Throwable)e);
                }
            }
            if (ex instanceof BrokerException) {
                throw (BrokerException)ex;
            }
            throw new BrokerException(ex.getMessage(), ex);
        }
    }

    private Subscription(DestinationUID d, String clientID, String selector, String subscriptionName, boolean share, boolean jmsshare, boolean noLocal, Integer sharecnt) throws IOException, SelectorFormatException, BrokerException {
        super(d, selector, noLocal, (ConnectionUID)null);
        this.isDurable = false;
        this.logger.log(4, "Creating Non-Durable Subscription " + this.uid + " with clientID " + clientID);
        this.getConsumerUID().setShouldStore(true);
        this.clientID = clientID;
        if (share) {
            if (sharecnt == null) {
                this.setShared(true);
            } else {
                this.setMaxNumActiveConsumers(sharecnt);
            }
        }
        this.jmsshared = jmsshare;
        this.ndSubscriptionName = subscriptionName;
        this.activeConsumers = new HashMap();
        this.active = false;
        this.hashcode = this.calcHashcode();
        this.ackMsgsOnDestroy = true;
    }

    public void setMaxNumActiveConsumers(int cnt) {
        this.maxNumActiveConsumers = cnt;
    }

    public int getMaxNumActiveConsumers() {
        return this.maxNumActiveConsumers;
    }

    public void setShared(boolean share) {
        this.maxNumActiveConsumers = share ? this.getFirstDestination().getMaxNumSharedConsumers() : 1;
    }

    public boolean getJMSShared() {
        return this.jmsshared;
    }

    public String getNDSubscriptionName() {
        return this.ndSubscriptionName;
    }

    public boolean getShared() {
        return this.maxNumActiveConsumers != 1;
    }

    @Override
    public void destroyConsumer(Set s, Map remotePendings, boolean remoteCleanup, boolean removeDest, boolean notify) {
        if (this.logger.isFineLoggable() || DEBUG) {
            this.logger.log(8, "Subscription.destroyConsumer(" + (s == null ? "," : "Set.size=" + s.size()) + (remotePendings == null ? "," : ", remotePending.size=" + remotePendings.size()) + ", remoteCleanup=" + remoteCleanup + ", removeDest=" + removeDest + ", notify=" + notify + ")" + this);
        }
        if (!this.valid) {
            return;
        }
        if (!this.isDurable) {
            for (Destination d : this.getDestinations()) {
                try {
                    d.removeConsumer(this.uid, remotePendings, remoteCleanup, false);
                }
                catch (Exception ex) {
                    this.logger.logStack(16, ex.getMessage(), (Throwable)ex);
                }
            }
        }
        super.destroyConsumer(s, remotePendings, remoteCleanup, removeDest, notify);
        if (this.stored) {
            try {
                Globals.getStore().removeInterest(this, Destination.PERSIST_SYNC);
                this.stored = false;
            }
            catch (Exception ex) {
                Object[] args = new String[]{Subscription.getDSubLogString(this.clientID, this.durableName), this.dest.toString()};
                this.logger.logStack(32, "B3148", args, (Throwable)ex);
            }
        }
    }

    public String getDurableName() {
        return this.durableName;
    }

    public void sendCreateSubscriptionNotification(Consumer consumer) throws BrokerException {
        Destination d = this.getFirstDestination();
        if (!(d != null && (d.getIsLocal() || d.isInternal() || d.isAdmin()) || Globals.getClusterBroadcast() == null)) {
            Globals.getClusterBroadcast().createSubscription(this, consumer);
        }
    }

    public void attachConsumer(Consumer consumer) throws BrokerException {
        this.attachConsumer(consumer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachConsumer(Consumer consumer, Connection conn) throws BrokerException {
        this.logger.log(4, "Attaching Consumer " + consumer + " to durable " + this + " with  " + this.msgs.size() + " msgs " + this.getDestinationUID() + "[" + this.getConsumerUID() + "]");
        Object object = this.subLock;
        synchronized (object) {
            if (this.activeConsumers.get(consumer.getConsumerUID()) != null) {
                throw new ConsumerAlreadyAddedException(Globals.getBrokerResources().getKString("B1331", consumer.getConsumerUID(), consumer.getDestinationUID()));
            }
            if (this.maxNumActiveConsumers == 1) {
                ConsumerUID kidc = consumer.getConsumerUID();
                this.uid.setConnectionUID(kidc.getConnectionUID());
                this.conuid = kidc.getConnectionUID();
            } else if (!this.activeConsumers.isEmpty() && consumer.noLocal != this.noLocal) {
                throw new IllegalStateException("nolocal must match on all consumers");
            }
            if (this.maxNumActiveConsumers != -1 && this.activeConsumers.size() >= this.maxNumActiveConsumers) {
                Object[] args = new String[]{this.getDestinations().toString(), this.toString(), String.valueOf(this.maxNumActiveConsumers), String.valueOf(this.activeConsumers.size())};
                throw new BrokerException(Globals.getBrokerResources().getKString("B4207", args), "B4207", null, 409);
            }
            boolean wasActive = this.isActive();
            consumer.setStoredConsumerUID(this.getConsumerUID());
            consumer.getConsumerUID().setShouldStore(true);
            this.activeConsumers.put(consumer.getConsumerUID(), consumer);
            if (this.msgsSubset == null) {
                this.msgsSubset = this.msgs.subSet((Filter)null);
            }
            consumer.setParentList(new NoPersistPartitionedStoreImpl(this.getStoredConsumerUID()), this.msgsSubset);
            consumer.setSubscription(this);
            this.active = !this.activeConsumers.isEmpty();
            DestinationList DL = Globals.getDestinationList();
            Map<PartitionedStore, LinkedHashSet<Destination>> dmap = DestinationList.findMatchingDestinationMap(null, this.getDestinationUID());
            LinkedHashSet<Destination> dset = null;
            for (Map.Entry<PartitionedStore, LinkedHashSet<Destination>> pair : dmap.entrySet()) {
                dset = pair.getValue();
                if (dset == null) continue;
                for (Destination d : dset) {
                    if (d == null) continue;
                    if (this.isActive() && !wasActive && !d.isLoaded()) {
                        this.logger.log(4, "Loading " + d);
                        try {
                            d.load();
                        }
                        catch (BrokerException e) {
                            this.logger.logStack(32, e.getMessage() + " [" + pair.getKey() + "]", (Throwable)e);
                        }
                    }
                    d.notifyConsumerAdded(consumer, conn);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void releaseConsumer(ConsumerUID uid) {
        this.logger.log(4, "Releasing Consumer " + uid + " from durable " + this);
        this.pause("Subscription: releaseConsumer " + uid);
        Consumer consumer = null;
        Object object = this.subLock;
        // MONITORENTER : object
        consumer = (Consumer)this.activeConsumers.remove(uid);
        consumer.pause("Subscription: releaseConsumer B ");
        consumer.setParentList(new NoPersistPartitionedStoreImpl(this.getStoredConsumerUID()), null);
        this.active = !this.activeConsumers.isEmpty();
        // MONITOREXIT : object
        DestinationList DL = Globals.getDestinationList();
        List[] ll = null;
        try {
            ll = DestinationList.findMatchingIDs(null, this.getDestinationUID());
        }
        catch (PartitionNotFoundException e) {
            ll = new List[]{new ArrayList()};
        }
        List l = ll[0];
        Iterator itr = l.iterator();
        Destination[] ds = null;
        Destination d = null;
        while (itr.hasNext()) {
            ds = DestinationList.getDestination(null, (DestinationUID)itr.next());
            d = ds[0];
            if (d == null) continue;
            d.notifyConsumerRemoved();
        }
        if (!this.isDurable) {
            Class<Subscription> clazz = Subscription.class;
            // MONITORENTER : com.sun.messaging.jmq.jmsserver.core.Subscription.class
            boolean bl = this.active = !this.activeConsumers.isEmpty();
            if (!this.active) {
                this.logger.log(4, "Cleaning up non-durable  subscription " + this);
                String key = Subscription.getNDSubKey(this.clientID, consumer.getDestinationUID(), this.selstr, this.getNDSubscriptionName());
                nonDurableList.remove(key);
                this.destroyConsumer(new HashSet(), null, false, true, false);
            }
            // MONITOREXIT : clazz
        }
        consumer.resume("Subscription: releaseConsumer B ");
        this.resume("Subscription: release consumer " + uid);
    }

    @Override
    public String getClientID() {
        return this.clientID;
    }

    @Override
    public String toString() {
        String str = "Subscription :" + this.uid + " - ";
        str = str + " dest=" + this.getDestinationUID();
        if (!this.isDurable) {
            return str;
        }
        str = str + Subscription.getDSubLogString(this.clientID, this.durableName);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() throws BrokerException {
        super.purgeConsumer();
        Object object = this.subLock;
        synchronized (object) {
            for (Consumer c : this.activeConsumers.values()) {
                c.purgeConsumer();
            }
        }
    }

    public String getDSubLongLogString() {
        return "[" + Subscription.getDSubKey(this.getClientID(), this.getDurableName()) + "]" + (this.getShared() ? (this.getJMSShared() ? "jms" : "mq") : "");
    }

    public static String getDSubKey(String cid, String dname) {
        return (cid == null ? "" : cid) + ":" + dname;
    }

    public static String getDSubLogString(String cid, String dname) {
        return "[" + Subscription.getDSubKey(cid, dname) + "]";
    }

    public static void clearSubscriptions() {
        nonDurableList.clear();
        cache.clear();
        durableList.clear();
        loaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initSubscriptions() {
        Logger logger = Globals.getLogger();
        logger.log(4, "Initializing consumers");
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            if (loaded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            loaded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            LoadException load_ex = null;
            try {
                load_ex = Globals.getStore().getLoadConsumerException();
            }
            catch (Exception ex) {
                logger.logStack(4, "Error loading consumer exception ", (Throwable)ex);
            }
            if (load_ex != null) {
                LoadException processing = load_ex;
                while (processing != null) {
                    ConsumerUID cuid = (ConsumerUID)processing.getKey();
                    Consumer con = (Consumer)processing.getValue();
                    if (cuid == null && con == null) {
                        logger.log(16, "LoadConsumerException: Both key and value are corrupted");
                        continue;
                    }
                    if (cuid == null) {
                        try {
                            Globals.getStore().storeInterest(con, true);
                        }
                        catch (Exception ex) {
                            logger.log(16, "B2094", (Object)con.getConsumerUID(), (Throwable)ex);
                        }
                    } else {
                        logger.log(16, "B2095", (Object)cuid.toString());
                        try {
                            Consumer c = new Consumer(cuid);
                            Globals.getStore().removeInterest(c, false);
                        }
                        catch (Exception ex) {
                            logger.logStack(4, "Error removing corrupt consumer " + cuid, (Throwable)ex);
                        }
                    }
                    processing = processing.getNextException();
                }
            }
            try {
                Consumer[] cons = Globals.getStore().getAllInterests();
                for (int i = 0; i < cons.length; ++i) {
                    Consumer c = cons[i];
                    if (c == null) continue;
                    assert (c instanceof Subscription);
                    Subscription s = (Subscription)c;
                    String clientID = s.getClientID();
                    if (clientID != null && clientID.length() == 0) {
                        clientID = null;
                    }
                    String durableName = s.getDurableName();
                    logger.log(8, Globals.getBrokerResources().getKString("B1435", Subscription.getDSubLogString(clientID, durableName)) + "[" + s.getDestinationUID() + "]");
                    String key = Subscription.getDSubKey(clientID, durableName);
                    if (durableList.get(key) != null) {
                        logger.log(16, "B3100", (Object)("The loaded durable subscription " + s + Subscription.getDSubLogString(clientID, durableName) + " from store already exists " + durableList.get(key) + ", replace"));
                    }
                    durableList.put(key, s);
                    DestinationUID duid = s.getDestinationUID();
                    DestinationList DL = Globals.getDestinationList();
                    LinkedHashSet<Destination> dset2 = null;
                    Map<PartitionedStore, LinkedHashSet<Destination>> dmap = null;
                    if (duid.isWildcard()) {
                        wildcardConsumers.add(c.getConsumerUID());
                        dmap = DestinationList.findMatchingDestinationMap(null, duid);
                        for (LinkedHashSet<Destination> dset2 : dmap.values()) {
                            if (dset2 == null) continue;
                            for (Destination d : dset2) {
                                if (d == null) continue;
                                if (DEBUG) {
                                    logger.log(8, "Add loaded durable subscription " + s + " to destination " + d);
                                }
                                d.addConsumer(s, false);
                            }
                        }
                        continue;
                    }
                    Destination[] ds = DestinationList.getDestination(null, duid.getName(), duid.isQueue() ? 1 : 2, true, true);
                    for (int j = 0; j < ds.length; ++j) {
                        if (ds[j] == null) continue;
                        if (DEBUG) {
                            logger.log(8, "Add loaded durable subscription " + s + " to destination " + ds[j]);
                        }
                        ds[j].addConsumer(s, false);
                    }
                }
            }
            catch (Exception ex) {
                logger.logStack(32, "B3146", (Throwable)ex);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initDuraSubscriptions(DestinationList dl) throws BrokerException {
        Subscription.initSubscriptions();
        if (!dl.setDuraSubscriptionInited()) {
            return;
        }
        try {
            DestinationList DL = Globals.getDestinationList();
            Subscription s2 = null;
            DestinationUID duid = null;
            Class<Subscription> clazz = Subscription.class;
            synchronized (Subscription.class) {
                for (Subscription s2 : durableList.values()) {
                    duid = s2.getDestinationUID();
                    if (duid.isWildcard()) {
                        List<DestinationUID> duids = DestinationList.findMatchingIDsByDestinationList(dl, duid);
                        for (DestinationUID match_duid : duids) {
                            Destination d = DestinationList.getDestinationByDestinationList(dl, match_duid);
                            d.addConsumer(s2, false, null, false);
                            Globals.getLogger().log(8, "XXXI18N added durable subscription " + s2 + " to " + dl);
                        }
                        continue;
                    }
                    Destination d = DestinationList.getDestinationByDestinationList(dl, duid.getName(), duid.isQueue() ? 1 : 2, true, true);
                    d.addConsumer(s2, false, null, false);
                    Globals.getLogger().log(8, "XXXI18N added durable subscription " + s2 + " to " + dl);
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            Globals.getLogger().logStack(32, e.getMessage(), (Throwable)e);
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            throw new BrokerException(e.getMessage(), e);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initNonDuraSharedSubscriptions(DestinationList dl) throws BrokerException {
        try {
            if (!dl.setNonDuraSharedSubscriptionInited()) {
                return;
            }
            DestinationList DL = Globals.getDestinationList();
            Subscription s2 = null;
            DestinationUID duid = null;
            Class<Subscription> clazz = Subscription.class;
            synchronized (Subscription.class) {
                for (Subscription s2 : nonDurableList.values()) {
                    duid = s2.getDestinationUID();
                    if (duid.isWildcard()) {
                        List<DestinationUID> duids = DestinationList.findMatchingIDsByDestinationList(dl, duid);
                        for (DestinationUID match_duid : duids) {
                            Destination d = DestinationList.getDestinationByDestinationList(dl, match_duid);
                            d.addConsumer(s2, false, null, false);
                            Globals.getLogger().log(8, "XXXI18N added non-durable shared subscription " + s2 + " to " + dl);
                        }
                        continue;
                    }
                    Destination d = DestinationList.getDestinationByDestinationList(dl, duid.getName(), duid.isQueue() ? 1 : 2, true, true);
                    d.addConsumer(s2, false, null, false);
                    Globals.getLogger().log(8, "XXXI18N added non-durable shared subscription " + s2 + " to " + dl);
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            Globals.getLogger().logStack(32, e.getMessage(), (Throwable)e);
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            throw new BrokerException(e.getMessage(), e);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAllDurableSubscriptions(DestinationUID uid) {
        HashSet<Subscription> s = new HashSet<Subscription>();
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            for (Subscription sub : durableList.values()) {
                if (uid != null && !uid.equals(sub.getDestinationUID())) continue;
                s.add(sub);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAllNonDurableSubscriptions(DestinationUID uid) {
        HashSet<Subscription> s = new HashSet<Subscription>();
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            for (Subscription sub : nonDurableList.values()) {
                if (uid != null && !uid.equals(sub.getDestinationUID())) continue;
                s.add(sub);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getAllSubscriptions(DestinationUID uid) {
        HashSet<Subscription> s = new HashSet<Subscription>();
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            for (Subscription sub : durableList.values()) {
                if (uid != null && !uid.equals(sub.getDestinationUID())) continue;
                s.add(sub);
            }
            for (Subscription sub : nonDurableList.values()) {
                if (uid != null && !uid.equals(sub.getDestinationUID())) continue;
                s.add(sub);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return s;
        }
    }

    public static Subscription remoteUnsubscribe(String durableName, String clientID) throws BrokerException {
        return Subscription.unsubscribe(durableName, clientID, false, false, false, false);
    }

    public static Subscription unsubscribe(String durableName, String clientID) throws BrokerException {
        return Subscription.unsubscribe(durableName, clientID, false, false);
    }

    public static Subscription unsubscribeOnDestroy(String durableName, String clientID, boolean notify) throws BrokerException {
        return Subscription.unsubscribe(durableName, clientID, false, true, notify, true);
    }

    public static Subscription unsubscribe(String durableName, String clientID, boolean override) throws BrokerException {
        return Subscription.unsubscribe(durableName, clientID, override, false);
    }

    private static Subscription unsubscribe(String durableName, String clientID, boolean override, boolean removingDest) throws BrokerException {
        return Subscription.unsubscribe(durableName, clientID, override, removingDest, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Subscription unsubscribe(String durableName, String clientID, boolean override, boolean removingDest, boolean notify, boolean recordRemoval) throws BrokerException {
        if (DEBUG) {
            Globals.getLogger().log(8, "Subscription.unsubscribe(" + durableName + ", " + clientID + ", " + override + ", " + removingDest + ", " + notify + ", " + recordRemoval + ")");
        }
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            String key = Subscription.getDSubKey(clientID, durableName);
            Subscription s = durableList.get(key);
            if (s == null) {
                DestinationUID did = (DestinationUID)cache.get((Object)key);
                if (did != null) {
                    Object[] args = new String[]{Subscription.getDSubLogString(clientID, durableName), did.toString()};
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4209", args), "B4209", null, 412);
                }
                throw new BrokerException(Globals.getBrokerResources().getKString("B4058", Subscription.getDSubLogString(clientID, durableName)), "B4058", null, 404);
            }
            if (s.isActive()) {
                if (override || removingDest) {
                    Iterator itr = null;
                    Object args = s.subLock;
                    synchronized (args) {
                        itr = new HashSet(s.activeConsumers.values()).iterator();
                    }
                    while (itr.hasNext()) {
                        Consumer c = (Consumer)itr.next();
                        c.destroyConsumer(new HashSet(), null, false, removingDest, notify);
                    }
                    s.activeConsumers.clear();
                } else {
                    Object[] args = new String[]{Subscription.getDSubLogString(clientID, durableName), s.getDestinationUID().getName()};
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4007", args), "B4007", null, 409);
                }
            }
            if (recordRemoval) {
                cache.put((Object)Subscription.getDSubKey(clientID, durableName), (Object)s.getDestinationUID());
            }
            if (notify) {
                Globals.getClusterBroadcast().recordUnsubscribe(s);
            }
            durableList.remove(key);
            s.destroyConsumer(new HashSet(), null, false, removingDest, notify);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Subscription subscribe(String name, boolean share, boolean jmsshare, String clientID, String sel, DestinationUID duid, boolean nolocal, boolean notify, boolean autostore, ConsumerUID requid, Integer sharecnt) throws BrokerException, SelectorFormatException {
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            Subscription s = Subscription.findDurableSubscription(clientID, name);
            if (s != null) {
                Object[] args = new String[]{Subscription.getDSubLogString(clientID, name), duid.toString()};
                throw new ConflictException(Globals.getBrokerResources().getKString("B4095", args));
            }
            try {
                s = new Subscription(duid, sel, nolocal, name, share, jmsshare, clientID, notify, autostore, requid, sharecnt);
            }
            catch (IOException ex) {
                Object[] args = new String[]{Subscription.getDSubLogString(clientID, name), duid.toString()};
                throw new BrokerException(Globals.getBrokerResources().getKString("B3149", args), ex);
            }
            durableList.put(Subscription.getDSubKey(clientID, name), s);
            // ** MonitorExit[var11_11] (shouldn't be in output)
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Subscription findDurableSubscription(String clientID, String durableName) {
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            assert (durableName != null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return durableList.get(Subscription.getDSubKey(clientID, durableName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Subscription findDurableSubscription(String key) {
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            assert (key != null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return durableList.get(key);
        }
    }

    public static Subscription findCreateDurableSubscription(String clientID, String durableName, boolean share, boolean jmsshare, DestinationUID uid, String selectorstr, boolean noLocal) throws BrokerException, SelectorFormatException {
        return Subscription.findCreateDurableSubscription(clientID, durableName, share, jmsshare, uid, selectorstr, noLocal, false, null, null);
    }

    public static Subscription findCreateDurableSubscription(String clientID, String durableName, boolean share, boolean jmsshare, DestinationUID uid, String selectorstr, boolean noLocal, boolean notify) throws BrokerException, SelectorFormatException {
        return Subscription.findCreateDurableSubscription(clientID, durableName, share, jmsshare, uid, selectorstr, noLocal, true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Subscription findCreateDurableSubscription(String clientID, String durableName, boolean share, boolean jmsshare, DestinationUID uid, String selectorstr, boolean noLocal, boolean notify, ConsumerUID requid, Integer sharecnt) throws BrokerException, SelectorFormatException {
        if (DEBUG) {
            Globals.getLogger().log(8, "Subscription.findCreateDurableSubscription(" + clientID + ", " + durableName + ", shared=" + share + ", jmsshare=" + jmsshare + ", duid=" + uid + ", selector=" + selectorstr + ", noLocal=" + noLocal + ", notify=" + notify + ", cuid=" + requid + ")");
        }
        Logger logger = Globals.getLogger();
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            Subscription s = Subscription.findDurableSubscription(clientID, durableName);
            if (s != null && (s.isActive() && !s.getShared() || s.getJMSShared() != jmsshare || !uid.equals(s.getDestinationUID()) || clientID != null && s.getNoLocal() != noLocal || (selectorstr != null || s.getSelectorStr() != null) && (selectorstr == null || !selectorstr.equals(s.getSelectorStr())))) {
                if (s.isActive() && !s.getShared()) {
                    Object[] args = new String[]{Subscription.getDSubLogString(clientID, durableName), uid.toString()};
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4095", args), "B4095", null, 409);
                }
                if (s.getJMSShared() != jmsshare) {
                    Object[] args = new String[]{s.getDSubLongLogString(), uid.toString()};
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4435", args), "B4435", null, 409);
                }
                if (s.isActive()) {
                    Object[] args = new String[]{Subscription.getDSubLogString(clientID, durableName), "" + s.getDestinationUID()};
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4440", args), "B4440", null, 409);
                }
                if (DEBUG) {
                    Globals.getLogger().log(8, "Subscription.findCreateDurableSubscription(" + clientID + ", " + durableName + ", " + share + ", " + jmsshare + ", " + uid + ", " + selectorstr + ", " + noLocal + ", " + notify + ", " + requid + "): not match, unsubscribe durable subscription " + s.getDSubLongLogString());
                }
                Subscription.unsubscribe(durableName, clientID, false, false, notify, false);
                s = null;
            }
            if (s == null) {
                if (DEBUG) {
                    logger.log(8, "Subscription.findCreateDurableSubscription(): Creating new durable subscription " + Subscription.getDSubLogString(clientID, durableName));
                }
                s = Subscription.subscribe(durableName, share, jmsshare, clientID, selectorstr, uid, noLocal, notify, true, requid, sharecnt);
                if (DEBUG) {
                    logger.log(8, "Subscription.findCreateDurableSubscription(): Created new durable subscription " + s.getDSubLongLogString());
                }
            }
            // ** MonitorExit[var11_11] (shouldn't be in output)
            return s;
        }
    }

    public static String getNDSubKey(String clientID, DestinationUID uid, String selectorstr, String subscriptionName) {
        if (subscriptionName == null) {
            return clientID + ":" + uid + ":" + selectorstr;
        }
        return clientID + ":" + subscriptionName;
    }

    public static String getNDSubLogString(String clientID, DestinationUID uid, String selectorstr, String subscriptionName) {
        return "[" + Subscription.getNDSubKey(clientID, uid, selectorstr, subscriptionName) + "]";
    }

    public static String getNDSubLongLogString(String clientID, DestinationUID uid, String selectorstr, String subscriptionName, boolean isNoLocal) {
        if (subscriptionName == null) {
            return Subscription.getNDSubLogString(clientID, uid, selectorstr, null) + "(" + isNoLocal + ")";
        }
        return Subscription.getNDSubLogString(clientID, uid, selectorstr, subscriptionName) + "(" + uid + ", " + selectorstr + ", " + isNoLocal + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Subscription findNonDurableSubscription(String clientID, DestinationUID uid, String selectorstr, String subscriptionName) {
        if (DEBUG) {
            Globals.getLogger().log(8, "Subscription.findNonDurableSubscription(" + clientID + ", " + uid + ", " + selectorstr + ", " + subscriptionName + ")");
        }
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            String key = Subscription.getNDSubKey(clientID, uid, selectorstr, subscriptionName);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return (Subscription)nonDurableList.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Subscription createAttachNonDurableSub(Consumer c, Connection con, String subscriptionName, boolean share, boolean jmsshare) throws BrokerException, IOException, SelectorFormatException {
        if (DEBUG) {
            Globals.getLogger().log(8, "Subscription.createAttachNonDurableSub(" + c + ", " + con + ", " + subscriptionName + ", " + share + ", " + jmsshare + ")");
        }
        String clientID = null;
        if (con != null) {
            clientID = (String)con.getClientData("client id");
        }
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            Subscription sub = Subscription.findCreateNonDurableSubscription(clientID, c.getSelectorStr(), subscriptionName, share, jmsshare, c.getDestinationUID(), c.getNoLocal(), null, null);
            sub.attachConsumer(c, con);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return sub;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Subscription findCreateNonDurableSubscription(String clientID, String selectorstr, String subscriptionName, boolean share, boolean jmsshare, DestinationUID duid, boolean isNoLocal, ConsumerUID optUID, Integer sharecnt) throws BrokerException, IOException, SelectorFormatException {
        if (DEBUG) {
            Globals.getLogger().log(8, "Subscription.findCreateNonDurableSubscription(" + clientID + ", " + selectorstr + ", " + subscriptionName + ", " + share + ", " + jmsshare + ", " + duid + ", " + isNoLocal + ", " + optUID + ", " + sharecnt + ")");
        }
        Class<Subscription> clazz = Subscription.class;
        synchronized (Subscription.class) {
            Subscription sub = Subscription.findNonDurableSubscription(clientID, duid, selectorstr, subscriptionName);
            if (DEBUG && sub != null) {
                Globals.getLogger().log(8, "Subscription.findCreateNonDurableSubscription(" + clientID + ", " + selectorstr + ", " + subscriptionName + ", " + share + ", " + jmsshare + ", " + duid + ", " + isNoLocal + ", " + optUID + ", " + sharecnt + ")\nFound Subscription:\n(" + sub.getClientID() + ", " + sub.getSelectorStr() + ", " + sub.getNDSubscriptionName() + ", " + sub.getDestinationUID() + ", " + sub.getNoLocal() + ")");
            }
            if (sub != null && subscriptionName != null && (Subscription.test2ObjectNotEqual(subscriptionName, sub.getNDSubscriptionName()) || !duid.equals(sub.getDestinationUID()) || Subscription.test2ObjectNotEqual(selectorstr, sub.getSelectorStr()) || Subscription.test2ObjectNotEqual(clientID, sub.getClientID()) || clientID != null && sub.getNoLocal() != isNoLocal)) {
                Object[] args = new String[]{Subscription.getNDSubLongLogString(clientID, duid, selectorstr, subscriptionName, isNoLocal), "" + duid, Subscription.getNDSubLongLogString(sub.getClientID(), sub.getDestinationUID(), sub.getSelectorStr(), sub.getNDSubscriptionName(), sub.getNoLocal()), "" + sub.getDestinationUID()};
                throw new BrokerException(Globals.getBrokerResources().getKString("B4441", args), 409);
            }
            if (sub == null) {
                sub = new Subscription(duid, clientID, selectorstr, subscriptionName, share, jmsshare, isNoLocal, sharecnt);
                if (optUID != null) {
                    sub.setConsumerUID(optUID);
                }
                String key = Subscription.getNDSubKey(clientID, duid, selectorstr, subscriptionName);
                if (DEBUG) {
                    Globals.getLogger().log(8, "Created new non-durable subscription " + key + "@" + sub.hashCode());
                }
                nonDurableList.put(key, sub);
            }
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return sub;
        }
    }

    private static boolean test2ObjectNotEqual(Object str1, Object str2) {
        return !(str1 == null && str2 == null || str1 != null && str1.equals(str2));
    }

    static {
        if (Globals.getLogger().getLevel() <= 4) {
            DEBUG = true;
        }
        loaded = false;
    }
}

