/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.domain;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.net.NetUtils;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DomainPortValidator {
    private static final Logger _logger = SLogger.getLogger();
    private static final LocalStringsImpl _strings = new LocalStringsImpl(DomainPortValidator.class);
    public static final int PORT_MAX_VAL = 65535;
    private DomainConfig _domainConfig;
    private Properties _defaultProps;

    DomainPortValidator(DomainConfig domainConfig, Properties defaultProps) {
        this._domainConfig = domainConfig;
        this._defaultProps = defaultProps;
    }

    public void validateAndSetPorts() throws DomainException {
        Properties domainProperties = this._domainConfig.getDomainProperties();
        try {
            Integer adminPortInt = this.getPort(domainProperties, "domain.adminPort", (String)this._domainConfig.get("domain.adminPort"), this._defaultProps.getProperty("ADMIN_PORT"), "Admin");
            this._domainConfig.add("domain.adminPort", adminPortInt);
            Integer instancePortInt = this.getPort(domainProperties, "domain.instancePort", (String)this._domainConfig.get("domain.instancePort"), this._defaultProps.getProperty("HTTP_PORT"), "HTTP Instance");
            this._domainConfig.add("domain.instancePort", instancePortInt);
            Integer jmsPort = this.getPort(domainProperties, "jms.port", null, this._defaultProps.getProperty("JMS_PROVIDER_PORT"), "JMS");
            this._domainConfig.add("jms.port", jmsPort);
            Integer orbPort = this.getPort(domainProperties, "orb.listener.port", null, this._defaultProps.getProperty("ORB_LISTENER_PORT"), "IIOP");
            this._domainConfig.add("orb.listener.port", orbPort);
            Integer httpSSLPort = this.getPort(domainProperties, "http.ssl.port", null, this._defaultProps.getProperty("HTTP_SSL_PORT"), "HTTP_SSL");
            this._domainConfig.add("http.ssl.port", httpSSLPort);
            Integer iiopSSLPort = this.getPort(domainProperties, "orb.ssl.port", null, this._defaultProps.getProperty("ORB_SSL_PORT"), "IIOP_SSL");
            this._domainConfig.add("orb.ssl.port", iiopSSLPort);
            Integer iiopMutualAuthPort = this.getPort(domainProperties, "orb.mutualauth.port", null, this._defaultProps.getProperty("ORB_MUTUALAUTH_PORT"), "IIOP_MUTUALAUTH");
            this._domainConfig.add("orb.mutualauth.port", iiopMutualAuthPort);
            Integer jmxPort = this.getPort(domainProperties, "domain.jmxPort", null, this._defaultProps.getProperty("JMX_SYSTEM_CONNECTOR_PORT"), "JMX_ADMIN");
            this._domainConfig.add("domain.jmxPort", jmxPort);
            Integer osgiShellTelnetPort = this.getPort(domainProperties, "osgi.shell.telnet.port", null, this._defaultProps.getProperty("OSGI_SHELL_TELNET_PORT"), "OSGI_SHELL");
            this._domainConfig.add("osgi.shell.telnet.port", osgiShellTelnetPort);
            Integer javaDebuggerPort = this.getPort(domainProperties, "java.debugger.port", null, this._defaultProps.getProperty("JAVA_DEBUGGER_PORT"), "JAVA_DEBUGGER");
            this._domainConfig.add("java.debugger.port", javaDebuggerPort);
            this.checkPortPrivilege(new Integer[]{adminPortInt, instancePortInt, jmsPort, orbPort, httpSSLPort, jmsPort, orbPort, httpSSLPort, iiopSSLPort, iiopMutualAuthPort, jmxPort, osgiShellTelnetPort, javaDebuggerPort});
        }
        catch (Exception ex) {
            throw new DomainException(ex);
        }
    }

    private Integer getPort(Properties properties, String key, String portStr, String defaultPort, String name) throws DomainException {
        Boolean checkPorts;
        int port = 0;
        boolean portNotSpecified = false;
        boolean invalidPortSpecified = false;
        boolean defaultPortUsed = false;
        if (portStr != null && !portStr.equals("")) {
            port = this.convertPortStr(portStr);
            if (port <= 0 || port > 65535) {
                invalidPortSpecified = true;
            }
        } else if (properties != null) {
            String property = properties.getProperty(key);
            if (property != null && !property.equals("")) {
                port = this.convertPortStr(property);
            } else {
                portNotSpecified = true;
            }
        } else {
            portNotSpecified = true;
        }
        if (portNotSpecified) {
            port = this.convertPortStr(defaultPort);
            defaultPortUsed = true;
        }
        if ((checkPorts = (Boolean)this._domainConfig.get("domain.validatePorts")).booleanValue() && !NetUtils.isPortFree((int)port)) {
            int newport = NetUtils.getFreePort();
            if (portNotSpecified) {
                if (defaultPortUsed) {
                    _logger.log(Level.INFO, "NCLS-SRVRMGMT-00014", new Object[]{name, defaultPort, Integer.toString(newport)});
                } else {
                    _logger.log(Level.INFO, "NCLS-SRVRMGMT-00015", new Object[]{name, Integer.toString(newport)});
                }
            } else if (invalidPortSpecified) {
                _logger.log(Level.INFO, "NCLS-SRVRMGMT-00016", new Object[]{name, Integer.toString(newport)});
            } else {
                _logger.log(Level.INFO, "NCLS-SRVRMGMT-00017", new Object[]{name, Integer.toString(port), Integer.toString(newport)});
            }
            port = newport;
        } else if (defaultPortUsed) {
            _logger.log(Level.INFO, "NCLS-SRVRMGMT-00018", new Object[]{name, Integer.toString(port)});
        } else {
            _logger.log(Level.INFO, "NCLS-SRVRMGMT-00019", new Object[]{name, Integer.toString(port)});
        }
        if (properties != null) {
            properties.remove(key);
        }
        return port;
    }

    private int convertPortStr(String port) throws DomainException {
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new DomainException(_strings.get("InvalidPortNumber", new Object[]{port}));
        }
    }

    private void checkPortPrivilege(Integer[] ports) {
        for (Integer port : ports) {
            int p = port;
            if (p >= 1024) continue;
            _logger.warning(_strings.get("PortPrivilege"));
            break;
        }
    }
}

