/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.impl.NamespaceTranslator;
import org.apache.felix.bundlerepository.impl.OSGiCapabilityAdapter;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FelixRequirementAdapter
implements org.osgi.resource.Requirement {
    private final Map<String, String> directives;
    private final Requirement requirement;
    private final Resource resource;

    public FelixRequirementAdapter(Requirement requirement, Resource resource) {
        if (requirement == null) {
            throw new NullPointerException("Missing required parameter: requirement");
        }
        if (resource == null) {
            throw new NullPointerException("Missing required parameter: resource");
        }
        this.requirement = requirement;
        this.resource = resource;
        this.directives = this.computeDirectives();
    }

    public Map<String, Object> getAttributes() {
        return this.requirement.getAttributes();
    }

    public Map<String, String> getDirectives() {
        return this.directives;
    }

    public String getNamespace() {
        return NamespaceTranslator.getOSGiNamespace(this.requirement.getName());
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean matches(Capability capability) {
        return this.requirement.isSatisfied(new OSGiCapabilityAdapter(capability));
    }

    private Map<String, String> computeDirectives() {
        HashMap<Object, Object> result = this.requirement.getDirectives() == null ? new HashMap() : new HashMap<String, String>(this.requirement.getDirectives());
        String filter = this.requirement.getFilter().replaceAll("\\(mandatory\\:\\<\\*[^\\)]*\\)", "").replaceAll("objectclass", "objectClass");
        for (String ns : NamespaceTranslator.getTranslatedFelixNamespaces()) {
            filter = filter.replaceAll("[(][ ]*" + ns + "[ ]*=", "(" + NamespaceTranslator.getOSGiNamespace(ns) + "=");
        }
        result.put("filter", filter);
        if (this.requirement.isOptional()) {
            result.put("resolution", "optional");
        }
        if (this.requirement.isMultiple()) {
            result.put("cardinality", "multiple");
        }
        return Collections.unmodifiableMap(result);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof org.osgi.resource.Requirement)) {
            return false;
        }
        org.osgi.resource.Requirement c = (org.osgi.resource.Requirement)o;
        return c.getNamespace().equals(this.getNamespace()) && c.getAttributes().equals(this.getAttributes()) && c.getDirectives().equals(this.getDirectives()) && c.getResource() != null ? c.getResource().equals((Object)this.getResource()) : this.getResource() == null;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getNamespace().hashCode();
        result = 31 * result + this.getAttributes().hashCode();
        result = 31 * result + this.getDirectives().hashCode();
        result = 31 * result + (this.getResource() == null ? 0 : this.getResource().hashCode());
        return result;
    }

    public String toString() {
        return this.resource + ":" + this.requirement;
    }
}

