/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.internal.actions;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.List;
import org.eclipse.glsp.server.actions.Action;

public class LoggingAction
extends Action {
    public static final String ID = "logging";
    private String severity;
    private String time;
    private String caller;
    private String message;
    private List<String> params;

    public LoggingAction() {
        super(ID);
    }

    public LoggingAction(Severity severity, String message) {
        this(severity, LoggingAction.class.getSimpleName(), message, Collections.emptyList());
    }

    public LoggingAction(Severity severity, String caller, String message) {
        this(severity, caller, message, Collections.emptyList());
    }

    public LoggingAction(Severity severity, String caller, String message, List<String> params) {
        this(severity, LocalTime.now().format(DateTimeFormatter.ofLocalizedTime(FormatStyle.LONG)), caller, message, params);
    }

    public LoggingAction(Severity severity, String time, String caller, String message, List<String> params) {
        super(ID);
        this.severity = severity.name().toLowerCase();
        this.time = time;
        this.caller = caller;
        this.message = message;
        this.params = params;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getCaller() {
        return this.caller;
    }

    public void setCaller(String caller) {
        this.caller = caller;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<String> getParams() {
        return this.params;
    }

    public void setParams(List<String> params) {
        this.params = params;
    }

    public static enum Severity {
        NONE,
        ERROR,
        WARN,
        INFO,
        LOG;

    }
}

