/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.jsonrpc;

import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.inject.Inject;
import org.eclipse.glsp.graph.gson.EnumTypeAdapter;
import org.eclipse.glsp.server.actions.ActionRegistry;
import org.eclipse.glsp.server.internal.json.ActionTypeAdapter;
import org.eclipse.glsp.server.jsonrpc.GraphGsonConfiguratorFactory;

public class GsonConfigurator {
    private final ActionRegistry actionRegistry;
    private final GraphGsonConfiguratorFactory gsonConfigurationFactory;

    @Inject
    public GsonConfigurator(ActionRegistry actionRegistry, GraphGsonConfiguratorFactory gsonConfigurationFactory) {
        this.actionRegistry = actionRegistry;
        this.gsonConfigurationFactory = gsonConfigurationFactory;
    }

    protected TypeAdapterFactory getActionTypeAdapterFactory() {
        return new ActionTypeAdapter.Factory(this.actionRegistry.getAll());
    }

    public GsonBuilder configureGsonBuilder(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapterFactory(this.getActionTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapter.Factory());
        return this.gsonConfigurationFactory.create().configureGsonBuilder(gsonBuilder);
    }
}

