/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.operations.gmodel;

import com.google.inject.Inject;
import java.util.Optional;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.operations.BasicOperationHandler;
import org.eclipse.glsp.server.operations.CompoundOperation;
import org.eclipse.glsp.server.operations.Operation;
import org.eclipse.glsp.server.operations.OperationActionHandler;
import org.eclipse.glsp.server.operations.OperationHandler;
import org.eclipse.glsp.server.operations.OperationHandlerRegistry;

public class CompoundOperationHandler
extends BasicOperationHandler<CompoundOperation> {
    @Inject
    protected OperationHandlerRegistry operationHandlerRegistry;

    @Override
    protected void executeOperation(CompoundOperation operation, GModelState modelState) {
        operation.getOperationList().forEach(nestedOperation -> this.executeNestedOperation((Operation)nestedOperation, modelState));
    }

    protected void executeNestedOperation(Operation operation, GModelState modelState) {
        Optional<? extends OperationHandler> operationHandler = OperationActionHandler.getOperationHandler(operation, this.operationHandlerRegistry);
        if (operationHandler.isPresent()) {
            operationHandler.get().execute(operation, modelState);
        }
    }
}

