/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.operations.gmodel;

import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.glsp.graph.GBoundsAware;
import org.eclipse.glsp.graph.GGraph;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.graph.util.GraphUtil;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.actions.SelectAction;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.operations.AbstractCreateOperationHandler;
import org.eclipse.glsp.server.operations.CreateNodeOperation;
import org.eclipse.glsp.server.utils.GeometryUtil;

public abstract class CreateNodeOperationHandler
extends AbstractCreateOperationHandler<CreateNodeOperation> {
    @Inject
    protected GModelState modelState;
    @Inject
    protected ActionDispatcher actionDispatcher;

    public CreateNodeOperationHandler(String elementTypeId) {
        super(elementTypeId);
    }

    @Override
    public void executeOperation(CreateNodeOperation operation) {
        Optional<GModelElement> container = this.getContainer(operation);
        if (!container.isPresent()) {
            container = Optional.of((GModelElement)this.modelState.getRoot());
        }
        Optional<GPoint> absoluteLocation = this.getLocation(operation);
        Optional<GPoint> relativeLocation = this.getRelativeLocation(operation, absoluteLocation, container);
        GNode element = this.createNode(relativeLocation, operation.getArgs());
        container.get().getChildren().add((Object)element);
        this.actionDispatcher.dispatchAfterNextUpdate(new SelectAction(), new SelectAction(List.of(element.getId())));
    }

    protected Optional<GModelElement> getContainer(CreateNodeOperation operation) {
        GModelIndex index = this.modelState.getIndex();
        return index.get(operation.getContainerId());
    }

    protected Optional<GPoint> getLocation(CreateNodeOperation operation) {
        return operation.getLocation();
    }

    protected Optional<GPoint> getRelativeLocation(CreateNodeOperation operation, Optional<GPoint> absoluteLocation, Optional<GModelElement> container) {
        if (absoluteLocation.isPresent() && container.isPresent()) {
            boolean allowNegativeCoordinates = container.get() instanceof GGraph;
            GModelElement modelElement = container.get();
            if (modelElement instanceof GBoundsAware) {
                try {
                    GPoint relativePosition = GeometryUtil.absoluteToRelative(absoluteLocation.get(), (GBoundsAware)modelElement);
                    GPoint relativeLocation = allowNegativeCoordinates ? relativePosition : GraphUtil.point((double)Math.max(0.0, relativePosition.getX()), (double)Math.max(0.0, relativePosition.getY()));
                    return Optional.of(relativeLocation);
                }
                catch (IllegalArgumentException ex) {
                    return absoluteLocation;
                }
            }
        }
        return Optional.empty();
    }

    protected abstract GNode createNode(Optional<GPoint> var1, Map<String, String> var2);
}

