/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.core.model;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.SetDirtyStateAction;
import org.eclipse.glsp.server.diagram.DiagramConfiguration;
import org.eclipse.glsp.server.features.core.model.GModelFactory;
import org.eclipse.glsp.server.features.core.model.RequestBoundsAction;
import org.eclipse.glsp.server.features.core.model.RequestModelAction;
import org.eclipse.glsp.server.features.core.model.SetModelAction;
import org.eclipse.glsp.server.features.core.model.UpdateModelAction;
import org.eclipse.glsp.server.features.validation.Marker;
import org.eclipse.glsp.server.features.validation.ModelValidator;
import org.eclipse.glsp.server.features.validation.SetMarkersAction;
import org.eclipse.glsp.server.layout.LayoutEngine;
import org.eclipse.glsp.server.layout.ServerLayoutKind;
import org.eclipse.glsp.server.model.GModelState;

@Singleton
public class ModelSubmissionHandler {
    @Inject
    protected Optional<LayoutEngine> layoutEngine;
    @Inject
    protected DiagramConfiguration diagramConfiguration;
    @Inject
    protected GModelFactory modelFactory;
    @Inject
    protected GModelState modelState;
    @Inject
    protected Optional<ModelValidator> validator;
    protected final Object modelLock = new Object();
    protected Optional<RequestModelAction> requestModelAction = Optional.empty();

    public List<Action> submitInitialModel(RequestModelAction requestAction) {
        this.requestModelAction = Optional.of(requestAction);
        return this.submitModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Action> submitModel(String reason) {
        this.modelFactory.createGModel();
        int revision = this.requestModelAction.isPresent() ? 0 : ((GModelRoot)this.modelState.getRoot()).getRevision() + 1;
        ((GModelRoot)this.modelState.getRoot()).setRevision(revision);
        boolean needsClientLayout = this.diagramConfiguration.needsClientLayout();
        if (needsClientLayout) {
            Object object = this.modelLock;
            synchronized (object) {
                return Arrays.asList(new RequestBoundsAction((GModelRoot)this.modelState.getRoot()), new SetDirtyStateAction(this.modelState.isDirty(), reason));
            }
        }
        return this.submitModelDirectly(reason);
    }

    public List<Action> submitModel() {
        return this.submitModel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Action> submitModelDirectly(String reason) {
        GModelRoot gModel = (GModelRoot)this.modelState.getRoot();
        if (this.diagramConfiguration.getLayoutKind() == ServerLayoutKind.AUTOMATIC && this.layoutEngine.isPresent()) {
            this.layoutEngine.get().layout();
        }
        Action modelAction = this.requestModelAction.isPresent() ? this.createSetModeAction(gModel) : new UpdateModelAction(gModel, this.diagramConfiguration.animatedUpdate());
        Object object = this.modelLock;
        synchronized (object) {
            ArrayList<Action> result = new ArrayList<Action>();
            result.add(modelAction);
            if (!this.diagramConfiguration.needsClientLayout()) {
                result.add(new SetDirtyStateAction(this.modelState.isDirty(), reason));
            }
            if (this.validator.isPresent()) {
                List<Marker> markers = this.validator.get().validate(Arrays.asList((GModelElement)this.modelState.getRoot()), "live");
                result.add(new SetMarkersAction(markers, "live"));
            }
            return result;
        }
    }

    public List<Action> submitModelDirectly() {
        return this.submitModelDirectly(null);
    }

    protected SetModelAction createSetModeAction(GModelRoot newRoot) {
        String requestId = this.requestModelAction.map(action -> action.getRequestId()).orElse("");
        SetModelAction response = new SetModelAction(newRoot);
        response.setResponseId(requestId);
        this.requestModelAction = Optional.empty();
        return response;
    }

    public synchronized Object getModelLock() {
        return this.modelLock;
    }
}

