/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.fonts.FontType;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFEncoding;
import org.apache.fop.pdf.PDFFontDescriptor;
import org.apache.fop.pdf.PDFFontTrueType;
import org.apache.fop.pdf.PDFFontType0;
import org.apache.fop.pdf.PDFFontType1;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStream;

public class PDFFont
extends PDFObject {
    protected String fontname;
    protected FontType subtype;
    protected String basefont;
    protected Object encoding;

    public PDFFont(String fontname, FontType subtype, String basefont, Object encoding) {
        this.fontname = fontname;
        this.subtype = subtype;
        this.basefont = basefont;
        this.encoding = encoding;
    }

    public static PDFFont createFont(String fontname, FontType subtype, String basefont, Object encoding) {
        if (subtype == FontType.TYPE0) {
            return new PDFFontType0(fontname, basefont, encoding);
        }
        if (subtype == FontType.TYPE1 || subtype == FontType.MMTYPE1) {
            return new PDFFontType1(fontname, basefont, encoding);
        }
        if (subtype == FontType.TYPE3) {
            return null;
        }
        if (subtype == FontType.TRUETYPE) {
            return new PDFFontTrueType(fontname, basefont, encoding);
        }
        return null;
    }

    public static PDFFont createFont(String fontname, FontType subtype, String basefont, Object encoding, int firstChar, int lastChar, PDFArray widths, PDFFontDescriptor descriptor) {
        if (subtype == FontType.TYPE0) {
            PDFFontType0 font = new PDFFontType0(fontname, basefont, encoding);
            font.setDescriptor(descriptor);
            return font;
        }
        if (subtype == FontType.TYPE1 || subtype == FontType.MMTYPE1) {
            PDFFontType1 font = new PDFFontType1(fontname, basefont, encoding);
            font.setWidthMetrics(firstChar, lastChar, widths);
            font.setDescriptor(descriptor);
            return font;
        }
        if (subtype == FontType.TYPE3) {
            return null;
        }
        if (subtype == FontType.TRUETYPE) {
            PDFFontTrueType font = new PDFFontTrueType(fontname, basefont, encoding);
            font.setWidthMetrics(firstChar, lastChar, widths);
            font.setDescriptor(descriptor);
            return font;
        }
        return null;
    }

    public String getName() {
        return this.fontname;
    }

    protected String getPDFNameForFontType(FontType fontType) {
        if (fontType == FontType.TYPE0) {
            return fontType.getName();
        }
        if (fontType == FontType.TYPE1) {
            return fontType.getName();
        }
        if (fontType == FontType.MMTYPE1) {
            return fontType.getName();
        }
        if (fontType == FontType.TYPE3) {
            return fontType.getName();
        }
        if (fontType == FontType.TRUETYPE) {
            return fontType.getName();
        }
        throw new IllegalArgumentException("Unsupported font type: " + fontType.getName());
    }

    public String toPDFString() {
        StringBuffer p = new StringBuffer(128);
        p.append(this.getObjectID());
        p.append("<< /Type /Font\n/Subtype /" + this.getPDFNameForFontType(this.subtype) + "\n/Name /" + this.fontname + "\n/BaseFont /" + this.basefont);
        if (this.encoding != null) {
            p.append("\n/Encoding ");
            if (this.encoding instanceof PDFEncoding) {
                p.append(((PDFEncoding)this.encoding).referencePDF());
            } else if (this.encoding instanceof PDFStream) {
                p.append(((PDFStream)this.encoding).referencePDF());
            } else {
                p.append("/").append((String)this.encoding);
            }
        }
        this.fillInPDF(p);
        p.append(" >>\nendobj\n");
        return p.toString();
    }

    protected void fillInPDF(StringBuffer target) {
    }
}

