/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IModel;
import org.eclipse.handly.util.ICollector;
import org.eclipse.handly.util.ToStringOptions;

public interface IElementImpl
extends IElement {
    public String getName_();

    public IElement getParent_();

    default public IElement getRoot_() {
        IElement parent = this.getParent_();
        if (parent == null) {
            return this;
        }
        return Elements.getRoot(parent);
    }

    default public boolean equalsAndSameParentChain_(IElement other) {
        if (this == other) {
            return true;
        }
        if (!this.equals(other)) {
            return false;
        }
        IElement parent = this.getParent_();
        IElement otherParent = Elements.getParent(other);
        if (parent == null) {
            return otherParent == null;
        }
        return Elements.equalsAndSameParentChain(parent, otherParent);
    }

    public IModel getModel_();

    default public String getHandleMemento_() {
        return null;
    }

    default public IResource getResource_() {
        return null;
    }

    default public URI getLocationUri_() {
        IResource resource = this.getResource_();
        if (resource != null) {
            return resource.getLocationURI();
        }
        return null;
    }

    public boolean exists_();

    public IElement[] getChildren_(IContext var1, IProgressMonitor var2) throws CoreException;

    default public <T> T[] getChildrenOfType_(Class<T> type, IContext context, IProgressMonitor monitor) throws CoreException {
        IElement[] children = this.getChildren_(context, monitor);
        if (type.isAssignableFrom(children.getClass().getComponentType())) {
            IElement[] result = children;
            return result;
        }
        ArrayList<T> list = new ArrayList<T>(children.length);
        IElement[] iElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IElement child = iElementArray[n2];
            if (type.isInstance(child)) {
                list.add(type.cast(child));
            }
            ++n2;
        }
        Object[] result = (Object[])Array.newInstance(type, list.size());
        return list.toArray(result);
    }

    default public void fetchChildren_(IContext context, ICollector<? super IElement> collector, IProgressMonitor monitor) throws CoreException {
        collector.addAll(Arrays.asList(this.getChildren_(context, monitor)));
    }

    default public <T> void fetchChildrenOfType_(Class<T> type, IContext context, ICollector<? super T> collector, IProgressMonitor monitor) throws CoreException {
        collector.addAll(Arrays.asList(this.getChildrenOfType_(type, context, monitor)));
    }

    public String toString_(IContext var1);

    default public String toDisplayString_(IContext context) {
        ToStringOptions.FormatStyle style = context.getOrDefault(ToStringOptions.FORMAT_STYLE);
        if (style != ToStringOptions.FormatStyle.SHORT && style != ToStringOptions.FormatStyle.MEDIUM) {
            context = Contexts.with(Contexts.of(ToStringOptions.FORMAT_STYLE, ToStringOptions.FormatStyle.MEDIUM), context);
        }
        return this.toString_(context);
    }
}

