/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.buffer;

import junit.framework.TestCase;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.handly.buffer.Buffer;
import org.eclipse.handly.buffer.BufferChange;
import org.eclipse.handly.buffer.BufferChangeOperation;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.buffer.UiBufferChangeRunner;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.handly.util.SimpleSynchronizer;
import org.eclipse.handly.util.UiSynchronizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class UiBufferChangeRunnerTest
extends TestCase {
    private IBuffer buffer;
    private SimpleSynchronizer synchronizer;

    protected void setUp() throws Exception {
        super.setUp();
        this.buffer = new Buffer();
        this.synchronizer = new SimpleSynchronizer();
    }

    protected void tearDown() throws Exception {
        if (this.synchronizer != null) {
            this.synchronizer.dispose();
        }
        super.tearDown();
    }

    public void test1() throws Exception {
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        IJobManager jobManager = Job.getJobManager();
        BufferChange change = new BufferChange((TextEdit)new InsertEdit(0, "foo"));
        BufferChangeOperation operation = new BufferChangeOperation(this.buffer, (IBufferChange)change, (ISchedulingRule)rule, jobManager){
            private final /* synthetic */ ISchedulingRule val$rule;
            private final /* synthetic */ IJobManager val$jobManager;
            {
                this.val$rule = iSchedulingRule;
                this.val$jobManager = iJobManager;
                super($anonymous0, $anonymous1);
            }

            public IBufferChange execute(IProgressMonitor monitor) throws CoreException, BadLocationException {
                UiBufferChangeRunnerTest.assertSame((Object)UiBufferChangeRunnerTest.this.synchronizer.getThread(), (Object)Thread.currentThread());
                UiBufferChangeRunnerTest.assertSame((Object)this.val$rule, (Object)this.val$jobManager.currentRule());
                return super.execute(monitor);
            }
        };
        try {
            jobManager.beginRule((ISchedulingRule)rule, null);
            new UiBufferChangeRunner((UiSynchronizer)this.synchronizer, operation).run((IProgressMonitor)new NullProgressMonitor());
            UiBufferChangeRunnerTest.assertEquals((String)"foo", (String)this.buffer.getDocument().get());
            UiBufferChangeRunnerTest.assertSame((Object)rule, (Object)jobManager.currentRule());
        }
        finally {
            jobManager.endRule((ISchedulingRule)rule);
        }
    }

    public void test2() throws Exception {
        this.synchronizer.syncExec(() -> {
            try {
                this.test1();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void test3() throws Exception {
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        IJobManager jobManager = Job.getJobManager();
        BufferChange change = new BufferChange((TextEdit)new InsertEdit(0, "foo"));
        change.setBase((ISnapshot)new DocumentSnapshot(this.buffer.getDocument()));
        this.buffer.getDocument().set("bar");
        BufferChangeOperation operation = new BufferChangeOperation(this.buffer, (IBufferChange)change, (ISchedulingRule)rule, jobManager){
            private final /* synthetic */ ISchedulingRule val$rule;
            private final /* synthetic */ IJobManager val$jobManager;
            {
                this.val$rule = iSchedulingRule;
                this.val$jobManager = iJobManager;
                super($anonymous0, $anonymous1);
            }

            public IBufferChange execute(IProgressMonitor monitor) throws CoreException, BadLocationException {
                UiBufferChangeRunnerTest.assertSame((Object)UiBufferChangeRunnerTest.this.synchronizer.getThread(), (Object)Thread.currentThread());
                UiBufferChangeRunnerTest.assertSame((Object)this.val$rule, (Object)this.val$jobManager.currentRule());
                return super.execute(monitor);
            }
        };
        try {
            jobManager.beginRule((ISchedulingRule)rule, null);
            try {
                new UiBufferChangeRunner((UiSynchronizer)this.synchronizer, operation).run((IProgressMonitor)new NullProgressMonitor());
                UiBufferChangeRunnerTest.fail();
            }
            catch (StaleSnapshotException staleSnapshotException) {
                // empty catch block
            }
            UiBufferChangeRunnerTest.assertSame((Object)rule, (Object)jobManager.currentRule());
        }
        finally {
            jobManager.endRule((ISchedulingRule)rule);
        }
    }
}

