/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl.support;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.buffer.Buffer;
import org.eclipse.handly.buffer.BufferChange;
import org.eclipse.handly.buffer.IBuffer;
import org.eclipse.handly.buffer.IBufferChange;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.junit.NoJobsWorkspaceTestCase;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.ISourceConstruct;
import org.eclipse.handly.model.ISourceElementInfo;
import org.eclipse.handly.model.impl.ISourceFileImplExtension;
import org.eclipse.handly.model.impl.support.SimpleModelManager;
import org.eclipse.handly.model.impl.support.SimpleSourceConstruct;
import org.eclipse.handly.model.impl.support.SimpleSourceFile;
import org.eclipse.handly.model.impl.support.SourceElementBody;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.TextFileSnapshot;
import org.eclipse.handly.util.Property;
import org.eclipse.handly.util.TextRange;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class SourceFileTest
extends NoJobsWorkspaceTestCase {
    private SimpleSourceFile sourceFile;
    private SimpleSourceConstruct aChild;

    protected void setUp() throws Exception {
        super.setUp();
        IFile file = this.setUpProject("Test001").getFile("a.foo");
        this.sourceFile = new SimpleSourceFile(null, file.getName(), file, new SimpleModelManager()){

            @Override
            public void buildSourceStructure_(IContext context, IProgressMonitor monitor) throws CoreException {
                SourceElementBody body = new SourceElementBody();
                if ("A".equals(context.get(SOURCE_CONTENTS))) {
                    body.addChild((IElement)SourceFileTest.this.aChild);
                    SourceElementBody aBody = new SourceElementBody();
                    aBody.setFullRange(new TextRange(0, 1));
                    ((Map)context.get(NEW_ELEMENTS)).put(SourceFileTest.this.aChild, aBody);
                }
                ((Map)context.get(NEW_ELEMENTS)).put(this, body);
            }
        };
        this.aChild = this.sourceFile.getChild("A");
    }

    public void test01() throws Exception {
        SourceFileTest.assertTrue((boolean)this.sourceFile.exists_());
        this.sourceFile.getFile_().delete(true, null);
        SourceFileTest.assertFalse((boolean)this.sourceFile.exists_());
        this.sourceFile.becomeWorkingCopy_(Contexts.EMPTY_CONTEXT, null);
        try {
            SourceFileTest.assertTrue((boolean)this.sourceFile.exists_());
        }
        finally {
            this.sourceFile.releaseWorkingCopy_();
        }
        SourceFileTest.assertFalse((boolean)this.sourceFile.exists_());
    }

    public void test02() throws Exception {
        ISourceElementInfo info = this.sourceFile.getSourceElementInfo_(Contexts.EMPTY_CONTEXT, null);
        SourceFileTest.assertEquals((int)0, (int)info.getChildren().length);
        SourceFileTest.assertEquals((Object)new TextRange(0, 0), (Object)info.getFullRange());
        SourceFileTest.assertNull((Object)info.getIdentifyingRange());
        SourceFileTest.assertTrue((boolean)new TextFileSnapshot(this.sourceFile.getFile_(), TextFileSnapshot.Layer.FILESYSTEM).isEqualTo(info.getSnapshot()));
        SourceFileTest.assertFalse((boolean)this.aChild.exists_());
    }

    public void test03() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (IBuffer buffer = this.sourceFile.getBuffer_(Contexts.EMPTY_CONTEXT, null);){
            buffer.applyChange((IBufferChange)new BufferChange((TextEdit)new InsertEdit(0, "A")), null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ISourceElementInfo info = this.sourceFile.getSourceElementInfo_(Contexts.EMPTY_CONTEXT, null);
        ISourceConstruct[] children = info.getChildren();
        SourceFileTest.assertEquals((int)1, (int)children.length);
        SourceFileTest.assertEquals((Object)((Object)this.aChild), (Object)children[0]);
        SourceFileTest.assertEquals((Object)new TextRange(0, 1), (Object)info.getFullRange());
        SourceFileTest.assertNull((Object)info.getIdentifyingRange());
        SourceFileTest.assertTrue((boolean)new TextFileSnapshot(this.sourceFile.getFile_(), TextFileSnapshot.Layer.FILESYSTEM).isEqualTo(info.getSnapshot()));
        this.assertChildInfo();
    }

    public void test04() throws Exception {
        this.test02();
        SourceFileTest.assertFalse((boolean)this.sourceFile.needsReconciling_());
        this.sourceFile.reconcile_(Contexts.EMPTY_CONTEXT, null);
        this.test02();
    }

    public void test05() throws Exception {
        this.test02();
        this.sourceFile.close_();
        this.test03();
    }

    public void test06() throws Exception {
        SourceFileTest.assertFalse((boolean)this.sourceFile.acquireExistingWorkingCopy_(null));
        boolean b = this.sourceFile.becomeWorkingCopy_(Contexts.EMPTY_CONTEXT, null);
        try {
            SourceFileTest.assertTrue((boolean)b);
            b = this.sourceFile.becomeWorkingCopy_(Contexts.EMPTY_CONTEXT, null);
            try {
                SourceFileTest.assertFalse((boolean)b);
                b = this.sourceFile.acquireExistingWorkingCopy_(null);
                try {
                    SourceFileTest.assertTrue((boolean)b);
                }
                finally {
                    SourceFileTest.assertFalse((boolean)this.sourceFile.releaseWorkingCopy_());
                }
            }
            finally {
                SourceFileTest.assertFalse((boolean)this.sourceFile.releaseWorkingCopy_());
            }
        }
        finally {
            SourceFileTest.assertTrue((boolean)this.sourceFile.releaseWorkingCopy_());
        }
    }

    public void test07() throws Exception {
        this.sourceFile.becomeWorkingCopy_(Contexts.EMPTY_CONTEXT, null);
        try {
            DocumentSnapshot snapshot;
            this.test02();
            SourceFileTest.assertFalse((boolean)this.sourceFile.needsReconciling_());
            this.sourceFile.reconcile_(Contexts.EMPTY_CONTEXT, null);
            this.test02();
            Throwable throwable = null;
            Object var3_3 = null;
            try (IBuffer buffer = this.sourceFile.getBuffer_(Contexts.EMPTY_CONTEXT, null);){
                IDocument document = buffer.getDocument();
                document.set("A");
                snapshot = new DocumentSnapshot(document);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            SourceFileTest.assertTrue((boolean)this.sourceFile.needsReconciling_());
            this.sourceFile.reconcile_(Contexts.EMPTY_CONTEXT, null);
            ISourceElementInfo info = this.sourceFile.getSourceElementInfo_(Contexts.EMPTY_CONTEXT, null);
            ISourceConstruct[] children = info.getChildren();
            SourceFileTest.assertEquals((int)1, (int)children.length);
            SourceFileTest.assertEquals((Object)((Object)this.aChild), (Object)children[0]);
            SourceFileTest.assertEquals((Object)new TextRange(0, 1), (Object)info.getFullRange());
            SourceFileTest.assertNull((Object)info.getIdentifyingRange());
            SourceFileTest.assertTrue((boolean)snapshot.isEqualTo(info.getSnapshot()));
            this.assertChildInfo();
        }
        finally {
            this.sourceFile.releaseWorkingCopy_();
        }
        this.test02();
    }

    public void test08() throws Exception {
        Buffer buffer = new Buffer("A");
        this.sourceFile.becomeWorkingCopy_(Contexts.of((Property)ISourceFileImplExtension.WORKING_COPY_BUFFER, (Object)buffer), null);
        try {
            ISourceElementInfo info = this.sourceFile.getSourceElementInfo_(Contexts.EMPTY_CONTEXT, null);
            ISourceConstruct[] children = info.getChildren();
            SourceFileTest.assertEquals((int)1, (int)children.length);
            SourceFileTest.assertEquals((Object)((Object)this.aChild), (Object)children[0]);
            SourceFileTest.assertEquals((Object)new TextRange(0, 1), (Object)info.getFullRange());
            SourceFileTest.assertNull((Object)info.getIdentifyingRange());
            SourceFileTest.assertTrue((boolean)new DocumentSnapshot(buffer.getDocument()).isEqualTo(info.getSnapshot()));
            this.assertChildInfo();
        }
        finally {
            this.sourceFile.releaseWorkingCopy_();
        }
        this.test02();
    }

    public void test09() throws Exception {
        SourceFileTest.assertNull((Object)this.sourceFile.peekAtBody_());
        this.sourceFile.becomeWorkingCopy_(Contexts.EMPTY_CONTEXT, null);
        try {
            SourceFileTest.assertNotNull((Object)this.sourceFile.peekAtBody_());
            this.sourceFile.close_();
            SourceFileTest.assertNotNull((Object)this.sourceFile.peekAtBody_());
        }
        finally {
            SourceFileTest.assertTrue((boolean)this.sourceFile.releaseWorkingCopy_());
        }
        SourceFileTest.assertNull((Object)this.sourceFile.peekAtBody_());
    }

    private void assertChildInfo() throws Exception {
        ISourceElementInfo info = this.aChild.getSourceElementInfo_(Contexts.EMPTY_CONTEXT, null);
        SourceFileTest.assertEquals((int)0, (int)info.getChildren().length);
        SourceFileTest.assertEquals((Object)new TextRange(0, 1), (Object)info.getFullRange());
        ISnapshot snapshot = this.sourceFile.getSourceElementInfo_(Contexts.EMPTY_CONTEXT, null).getSnapshot();
        SourceFileTest.assertNotNull((Object)snapshot);
        SourceFileTest.assertTrue((boolean)snapshot.isEqualTo(info.getSnapshot()));
    }
}

