/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli.adapter;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonMessageHandler;
import io.vertx.proton.ProtonQoS;
import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.ProtonSender;
import javax.annotation.PostConstruct;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.cli.adapter.AmqpCliClient;
import org.eclipse.hono.util.MessageHelper;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"amqp-command"})
public class CommandAndControlClient
extends AmqpCliClient {
    private ProtonSender sender;

    @PostConstruct
    void start() {
        this.startCommandReceiver((d, m) -> {
            boolean isOneWay;
            String commandPayload = null;
            if (m.getBody() instanceof Data) {
                byte[] body = ((Data)m.getBody()).getValue().getArray();
                commandPayload = new String(body);
            }
            boolean bl = isOneWay = m.getReplyTo() == null;
            if (isOneWay) {
                this.writer.printf("received one-way command [name: %s]: %s%n", m.getSubject(), commandPayload);
                this.writer.flush();
            } else {
                this.writer.printf("received command [name: %s]: %s%n", m.getSubject(), commandPayload);
                this.writer.flush();
                Message commandResponse = ProtonHelper.message((String)m.getReplyTo(), (String)("OK: " + m.getSubject()));
                commandResponse.setCorrelationId(m.getCorrelationId());
                MessageHelper.addProperty((Message)commandResponse, (String)"status", (Object)200);
                commandResponse.setContentType(m.getContentType());
                this.sender.send(commandResponse, delivery -> {
                    if (delivery.remotelySettled()) {
                        this.writer.printf("sent response to command [name: %s, outcome: %s]%n", m.getSubject(), delivery.getRemoteState().getType());
                    } else {
                        this.writer.println("application did not settle command response message");
                    }
                    this.writer.flush();
                });
            }
        }).otherwise(t -> {
            this.writer.printf("failed to create command receiver link: %s%n", t.getMessage()).flush();
            System.exit(1);
            return null;
        });
    }

    private Future<ProtonReceiver> startCommandReceiver(ProtonMessageHandler msgHandler) {
        return this.connectToAdapter().compose(con -> {
            this.log.info("connection to AMQP adapter established");
            this.adapterConnection = con;
            return this.createSender();
        }).compose(s -> {
            this.sender = s;
            return this.subscribeToCommands(msgHandler);
        });
    }

    private Future<ProtonReceiver> subscribeToCommands(ProtonMessageHandler msgHandler) {
        Promise result = Promise.promise();
        ProtonReceiver receiver = this.adapterConnection.createReceiver("command");
        receiver.setQoS(ProtonQoS.AT_LEAST_ONCE);
        receiver.handler(msgHandler);
        receiver.openHandler((Handler)result);
        receiver.open();
        return result.future().map(recver -> {
            this.writer.println("Device is now ready to receive commands (Press Ctrl + c to terminate)");
            this.writer.flush();
            return recver;
        });
    }
}

