/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.subscription;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.subscription.ContextSupport;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class SafeSubscriber<T>
implements Subscriber<T>,
Subscription,
ContextSupport {
    private final Subscriber<? super T> downstream;
    private Subscription upstream;
    private final AtomicBoolean subscribed = new AtomicBoolean(false);
    private boolean done;

    public SafeSubscriber(Subscriber<? super T> downstream) {
        this.downstream = downstream;
    }

    boolean isDone() {
        return this.done;
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        if (this.subscribed.compareAndSet(false, true)) {
            this.upstream = subscription;
            try {
                this.downstream.onSubscribe(this);
            }
            catch (Throwable e) {
                this.done = true;
                try {
                    subscription.cancel();
                }
                catch (Throwable e1) {
                    Infrastructure.handleDroppedException(e1);
                }
            }
        } else {
            subscription.cancel();
        }
    }

    @Override
    public void onNext(T t) {
        if (this.done) {
            return;
        }
        if (this.upstream == null) {
            this.onNextNoSubscription();
            return;
        }
        if (t == null) {
            NullPointerException ex = new NullPointerException("onNext called with null.");
            this.cancelAndDispatch(ex);
            throw ex;
        }
        try {
            this.downstream.onNext(t);
        }
        catch (Throwable e) {
            this.cancelAndDispatch(e);
        }
    }

    private void cancelAndDispatch(Throwable ex) {
        try {
            this.upstream.cancel();
        }
        catch (Throwable e1) {
            this.onError(new CompositeException(ex, e1));
            return;
        }
        this.onError(ex);
    }

    private void onNextNoSubscription() {
        this.done = true;
        this.manageViolationProtocol();
    }

    @Override
    public void onError(Throwable t) {
        Objects.requireNonNull(t);
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.upstream == null) {
            NullPointerException npe = new NullPointerException("Subscription not set!");
            try {
                this.downstream.onSubscribe(Subscriptions.empty());
            }
            catch (Throwable e) {
                Infrastructure.handleDroppedException(new CompositeException(t, e));
                return;
            }
            try {
                this.downstream.onError(new CompositeException(t, npe));
            }
            catch (Throwable e) {
                Infrastructure.handleDroppedException(new CompositeException(t, npe, e));
            }
            return;
        }
        try {
            this.downstream.onError(t);
        }
        catch (Throwable ex) {
            Infrastructure.handleDroppedException(new CompositeException(t, ex));
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.upstream == null) {
            this.onCompleteNoSubscription();
            return;
        }
        try {
            this.downstream.onComplete();
        }
        catch (Throwable e) {
            Infrastructure.handleDroppedException(e);
        }
    }

    private void onCompleteNoSubscription() {
        this.manageViolationProtocol();
    }

    private void manageViolationProtocol() {
        NullPointerException ex = new NullPointerException("Subscription not set!");
        try {
            this.downstream.onSubscribe(Subscriptions.empty());
        }
        catch (Throwable e) {
            Infrastructure.handleDroppedException(new CompositeException(ex, e));
            return;
        }
        try {
            this.downstream.onError(ex);
        }
        catch (Throwable e) {
            Infrastructure.handleDroppedException(new CompositeException(ex, e));
        }
    }

    @Override
    public void request(long n) {
        try {
            this.upstream.request(n);
        }
        catch (Throwable e) {
            try {
                this.upstream.cancel();
            }
            catch (Throwable ex) {
                Infrastructure.handleDroppedException(new CompositeException(e, ex));
            }
        }
    }

    @Override
    public void cancel() {
        try {
            this.upstream.cancel();
        }
        catch (Throwable e) {
            Infrastructure.handleDroppedException(e);
        }
    }

    @Override
    public Context context() {
        if (this.downstream instanceof ContextSupport) {
            return ((ContextSupport)((Object)this.downstream)).context();
        }
        return Context.empty();
    }
}

