/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command;

import io.vertx.core.buffer.Buffer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.hono.client.command.CommandRequestIdParameters;
import org.eclipse.hono.client.command.Commands;
import org.eclipse.hono.util.MessagingType;
import org.eclipse.hono.util.Pair;
import org.eclipse.hono.util.ResourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommandResponse {
    private static final Logger LOG = LoggerFactory.getLogger(CommandResponse.class);
    private static final Predicate<Integer> INVALID_STATUS_CODE = code -> code == null || code < 200 || code >= 300 && code < 400 || code >= 600;
    private final String tenantId;
    private final String deviceId;
    private final Buffer payload;
    private final String contentType;
    private final int status;
    private final String correlationId;
    private final String replyToId;
    private final MessagingType messagingType;
    private Map<String, Object> additionalProperties;

    public CommandResponse(String tenantId, String deviceId, Buffer payload, String contentType, int status, String correlationId, String replyToId, MessagingType messagingType) {
        this.tenantId = Objects.requireNonNull(tenantId);
        this.deviceId = Objects.requireNonNull(deviceId);
        this.payload = payload;
        this.contentType = contentType;
        this.status = status;
        this.correlationId = Objects.requireNonNull(correlationId);
        this.replyToId = Objects.requireNonNull(replyToId);
        this.messagingType = Objects.requireNonNull(messagingType);
    }

    public static CommandResponse fromRequestId(String requestId, String tenantId, String deviceId, Buffer payload, String contentType, Integer status) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        if (requestId == null) {
            LOG.debug("cannot create CommandResponse: request id is null");
            return null;
        }
        if (INVALID_STATUS_CODE.test(status)) {
            LOG.debug("cannot create CommandResponse: status is invalid: {}", (Object)status);
            return null;
        }
        try {
            CommandRequestIdParameters requestParams = Commands.decodeRequestIdParameters(requestId, deviceId);
            return new CommandResponse(tenantId, deviceId, payload, contentType, status, requestParams.getCorrelationId(), requestParams.getReplyToId(), requestParams.getMessagingType());
        }
        catch (IllegalArgumentException e) {
            LOG.debug("error creating CommandResponse", e);
            return null;
        }
    }

    public static CommandResponse fromAddressAndCorrelationId(String address, String correlationId, Buffer payload, String contentType, Integer status) {
        if (correlationId == null || !ResourceIdentifier.isValid(address) || status == null) {
            LOG.debug("cannot create CommandResponse: invalid message (correlationId: {}, address: {}, status: {})", correlationId, address, status);
            return null;
        }
        if (INVALID_STATUS_CODE.test(status)) {
            LOG.debug("cannot create CommandResponse: status is invalid: {}", (Object)status);
            return null;
        }
        ResourceIdentifier resource = ResourceIdentifier.fromString(address);
        String tenantId = resource.getTenantId();
        String deviceId = resource.getResourceId();
        if (tenantId == null || deviceId == null) {
            LOG.debug("cannot create CommandResponse: invalid address, missing tenant and/or device identifier");
            return null;
        }
        try {
            Pair<String, MessagingType> replyToIdMessagingTypePair = Commands.getOriginalReplyToIdAndMessagingType(resource.getPathWithoutBase(), deviceId);
            return new CommandResponse(tenantId, deviceId, payload, contentType, status, correlationId, replyToIdMessagingTypePair.one(), replyToIdMessagingTypePair.two());
        }
        catch (IllegalArgumentException e) {
            LOG.debug("error creating CommandResponse: invalid address, invalid last path component", e);
            return null;
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public Buffer getPayload() {
        return this.payload;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getReplyToId() {
        return this.replyToId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public int getStatus() {
        return this.status;
    }

    public MessagingType getMessagingType() {
        return this.messagingType;
    }

    public Map<String, Object> getAdditionalProperties() {
        return Optional.ofNullable(this.additionalProperties).orElseGet(Map::of);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public String toString() {
        return "CommandResponse{tenantId='" + this.tenantId + "', deviceId='" + this.deviceId + "', contentType='" + this.contentType + "', status=" + this.status + ", correlationId='" + this.correlationId + "', replyToId='" + this.replyToId + "', messagingType='" + this.messagingType + "'}";
    }
}

