/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkus.runtime.annotations.RegisterForReflection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@RegisterForReflection
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class CommandEndpoint {
    private String uri;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, Object> payloadProperties = new HashMap<String, Object>();

    @JsonProperty(value="uri")
    public String getUri() {
        return this.uri;
    }

    public CommandEndpoint setUri(String uri) {
        this.uri = uri;
        return this;
    }

    @JsonProperty(value="headers")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public CommandEndpoint setHeaders(Map<String, String> headers) {
        this.headers.clear();
        Optional.ofNullable(headers).ifPresent(this.headers::putAll);
        return this;
    }

    @JsonProperty(value="payload-properties")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getPayloadProperties() {
        return Collections.unmodifiableMap(this.payloadProperties);
    }

    public CommandEndpoint setPayloadProperties(Map<String, String> payloadProperties) {
        this.payloadProperties.clear();
        Optional.ofNullable(payloadProperties).ifPresent(this.payloadProperties::putAll);
        return this;
    }

    @JsonIgnore
    public boolean isUriValid() {
        if (this.uri == null) {
            return false;
        }
        try {
            new URI(this.getFormattedUri("deviceId"));
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    @JsonIgnore
    public String getFormattedUri(String deviceId) {
        Objects.requireNonNull(deviceId);
        return this.uri.replace("{{deviceId}}", deviceId);
    }
}

