/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.DelegatingSslContext;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.Mapping;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.ClientOptionsBase;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.VertxTrustManagerFactory;
import io.vertx.core.spi.tls.DefaultSslContextFactory;
import io.vertx.core.spi.tls.SslContextFactory;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class SSLHelper {
    private static final EnumMap<ClientAuth, io.netty.handler.ssl.ClientAuth> CLIENT_AUTH_MAPPING = new EnumMap(ClientAuth.class);
    private static final Logger log;
    private final boolean ssl;
    private final boolean sni;
    private final long sslHandshakeTimeout;
    private final TimeUnit sslHandshakeTimeoutUnit;
    private final boolean trustAll;
    private final ClientAuth clientAuth;
    private final boolean client;
    private final boolean useAlpn;
    private final Set<String> enabledProtocols;
    private final String endpointIdentificationAlgorithm;
    private final SSLEngineOptions sslEngineOptions;
    private final KeyCertOptions keyCertOptions;
    private final TrustOptions trustOptions;
    private final ArrayList<String> crlPaths;
    private final ArrayList<Buffer> crlValues;
    private final Set<String> enabledCipherSuites;
    private final List<String> applicationProtocols;
    private Future<Supplier<SslContextFactory>> sslProvider;
    private SslContext[] sslContexts = new SslContext[2];
    private Map<String, SslContext>[] sslContextMaps = new Map[]{new ConcurrentHashMap(), new ConcurrentHashMap()};

    public static SSLEngineOptions resolveEngineOptions(SSLEngineOptions engineOptions, boolean useAlpn) {
        if (engineOptions == null && useAlpn) {
            if (JdkSSLEngineOptions.isAlpnAvailable()) {
                engineOptions = new JdkSSLEngineOptions();
            } else if (OpenSSLEngineOptions.isAlpnAvailable()) {
                engineOptions = new OpenSSLEngineOptions();
            }
        }
        if (engineOptions == null) {
            engineOptions = new JdkSSLEngineOptions();
        } else if (engineOptions instanceof OpenSSLEngineOptions && !OpenSsl.isAvailable()) {
            VertxException ex = new VertxException("OpenSSL is not available");
            Throwable cause = OpenSsl.unavailabilityCause();
            if (cause != null) {
                ex.initCause(cause);
            }
            throw ex;
        }
        if (useAlpn) {
            if (engineOptions instanceof JdkSSLEngineOptions && !JdkSSLEngineOptions.isAlpnAvailable()) {
                throw new VertxException("ALPN not available for JDK SSL/TLS engine");
            }
            if (engineOptions instanceof OpenSSLEngineOptions && !OpenSSLEngineOptions.isAlpnAvailable()) {
                throw new VertxException("ALPN is not available for OpenSSL SSL/TLS engine");
            }
        }
        return engineOptions;
    }

    public SSLHelper(TCPSSLOptions options, List<String> applicationProtocols) {
        this.sslEngineOptions = options.getSslEngineOptions();
        this.crlPaths = new ArrayList<String>(options.getCrlPaths());
        this.crlValues = new ArrayList<Buffer>(options.getCrlValues());
        this.enabledCipherSuites = new HashSet<String>(options.getEnabledCipherSuites());
        this.ssl = options.isSsl();
        this.sslHandshakeTimeout = options.getSslHandshakeTimeout();
        this.sslHandshakeTimeoutUnit = options.getSslHandshakeTimeoutUnit();
        this.useAlpn = options.isUseAlpn();
        this.enabledProtocols = options.getEnabledSecureTransportProtocols();
        this.client = options instanceof ClientOptionsBase;
        this.trustAll = options instanceof ClientOptionsBase && ((ClientOptionsBase)options).isTrustAll();
        this.keyCertOptions = options.getKeyCertOptions() != null ? options.getKeyCertOptions().copy() : null;
        this.trustOptions = options.getTrustOptions() != null ? options.getTrustOptions().copy() : null;
        this.clientAuth = options instanceof NetServerOptions ? ((NetServerOptions)options).getClientAuth() : ClientAuth.NONE;
        this.endpointIdentificationAlgorithm = options instanceof NetClientOptions ? ((NetClientOptions)options).getHostnameVerificationAlgorithm() : "";
        this.sni = options instanceof NetServerOptions && ((NetServerOptions)options).isSni();
        this.applicationProtocols = applicationProtocols;
    }

    public boolean isSSL() {
        return this.ssl;
    }

    public boolean isSNI() {
        return this.sni;
    }

    private void configureEngine(SSLEngine engine, String serverName) {
        SSLParameters sslParameters;
        LinkedHashSet<String> protocols = new LinkedHashSet<String>(this.enabledProtocols);
        protocols.retainAll(Arrays.asList(engine.getSupportedProtocols()));
        if (protocols.isEmpty()) {
            log.warn("no SSL/TLS protocols are enabled due to configuration restrictions");
        }
        engine.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
        if (this.client && !this.endpointIdentificationAlgorithm.isEmpty()) {
            sslParameters = engine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm(this.endpointIdentificationAlgorithm);
            engine.setSSLParameters(sslParameters);
        }
        if (serverName != null) {
            sslParameters = engine.getSSLParameters();
            sslParameters.setServerNames(Collections.singletonList(new SNIHostName(serverName)));
            engine.setSSLParameters(sslParameters);
        }
    }

    public synchronized Future<Void> init(ContextInternal ctx) {
        Promise promise;
        Future<Supplier<SslContextFactory>> fut = this.sslProvider;
        if (fut == null) {
            if (this.keyCertOptions != null || this.trustOptions != null || this.trustAll || this.ssl) {
                promise = Promise.promise();
                fut = promise.future();
                ctx.executeBlockingInternal(p -> {
                    KeyManagerFactory kmf;
                    try {
                        this.getTrustMgrFactory(ctx.owner(), null, false);
                        kmf = this.getKeyMgrFactory(ctx.owner());
                    }
                    catch (Exception e) {
                        p.fail(e);
                        return;
                    }
                    if (this.client || kmf != null) {
                        p.complete();
                    } else {
                        p.fail("Key/certificate is mandatory for SSL");
                    }
                }).compose(v2 -> ctx.executeBlockingInternal(p -> {
                    Supplier<SslContextFactory> sslProvider;
                    try {
                        SSLEngineOptions resolvedEngineOptions = SSLHelper.resolveEngineOptions(this.sslEngineOptions, this.useAlpn);
                        sslProvider = resolvedEngineOptions::sslContextFactory;
                    }
                    catch (Exception e) {
                        p.fail(e);
                        return;
                    }
                    p.complete(sslProvider);
                })).onComplete(promise);
            } else {
                fut = Future.succeededFuture(() -> new DefaultSslContextFactory(SslProvider.JDK, false));
            }
            this.sslProvider = fut;
        }
        promise = ctx.promise();
        fut.mapEmpty().onComplete(promise);
        return promise.future();
    }

    public Mapping<? super String, ? extends SslContext> serverNameMapper(VertxInternal vertx) {
        return serverName -> {
            SslContext ctx = this.createContext(vertx, (String)serverName, this.useAlpn, this.client, this.trustAll);
            if (ctx != null) {
                ctx = new DelegatingSslContext(ctx, (String)serverName){
                    final /* synthetic */ String val$serverName;
                    {
                        this.val$serverName = string;
                        super(x0);
                    }

                    @Override
                    protected void initEngine(SSLEngine engine) {
                        SSLHelper.this.configureEngine(engine, this.val$serverName);
                    }
                };
            }
            return ctx;
        };
    }

    public SSLEngine createEngine(VertxInternal vertx) {
        SSLEngine engine = this.createContext(vertx).newEngine(ByteBufAllocator.DEFAULT);
        this.configureEngine(engine, null);
        return engine;
    }

    public SslContext createContext(VertxInternal vertx) {
        return this.createContext(vertx, null, this.useAlpn, this.client, this.trustAll);
    }

    public SslContext createContext(VertxInternal vertx, String serverName, boolean useAlpn, boolean client, boolean trustAll) {
        int idx;
        int n = idx = useAlpn ? 0 : 1;
        if (serverName == null) {
            if (this.sslContexts[idx] == null) {
                this.sslContexts[idx] = this.createContext2(vertx, serverName, useAlpn, client, trustAll);
            }
            return this.sslContexts[idx];
        }
        return this.sslContextMaps[idx].computeIfAbsent(serverName, s -> this.createContext2(vertx, serverName, useAlpn, client, trustAll));
    }

    public SslContext sslContext(VertxInternal vertx, final String serverName, boolean useAlpn) {
        SslContext context = this.createContext(vertx, null, useAlpn, this.client, this.trustAll);
        return new DelegatingSslContext(context){

            @Override
            protected void initEngine(SSLEngine engine) {
                SSLHelper.this.configureEngine(engine, serverName);
            }
        };
    }

    private SslContext createContext2(VertxInternal vertx, String serverName, boolean useAlpn, boolean client, boolean trustAll) {
        try {
            TrustManagerFactory tmf = this.getTrustMgrFactory(vertx, serverName, trustAll);
            KeyManagerFactory kmf = this.getKeyMgrFactory(vertx, serverName);
            SslContextFactory factory = this.sslProvider.result().get().useAlpn(useAlpn).forClient(client).enabledCipherSuites(this.enabledCipherSuites).applicationProtocols(this.applicationProtocols);
            if (!client) {
                factory.clientAuth(CLIENT_AUTH_MAPPING.get((Object)this.clientAuth));
            }
            if (kmf != null) {
                factory.keyMananagerFactory(kmf);
            }
            if (tmf != null) {
                factory.trustManagerFactory(tmf);
            }
            if (serverName != null) {
                factory.serverName(serverName);
            }
            return factory.create();
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    public SslHandler createSslHandler(VertxInternal vertx, String serverName) {
        return this.createSslHandler(vertx, null, serverName);
    }

    public SslHandler createSslHandler(VertxInternal vertx, SocketAddress remoteAddress, String serverName) {
        return this.createSslHandler(vertx, remoteAddress, serverName, this.useAlpn);
    }

    public SslHandler createSslHandler(VertxInternal vertx, SocketAddress remoteAddress, String serverName, boolean useAlpn) {
        SslContext sslContext = this.sslContext(vertx, serverName, useAlpn);
        SslHandler sslHandler = remoteAddress == null || remoteAddress.isDomainSocket() ? sslContext.newHandler(ByteBufAllocator.DEFAULT) : sslContext.newHandler(ByteBufAllocator.DEFAULT, remoteAddress.host(), remoteAddress.port());
        sslHandler.setHandshakeTimeout(this.sslHandshakeTimeout, this.sslHandshakeTimeoutUnit);
        return sslHandler;
    }

    public SniHandler createSniHandler(VertxInternal vertx) {
        return new SniHandler(this.serverNameMapper(vertx));
    }

    public ChannelHandler createHandler(VertxInternal vertx) {
        if (this.sni) {
            return this.createSniHandler(vertx);
        }
        return this.createSslHandler(vertx, null);
    }

    private KeyManagerFactory getKeyMgrFactory(VertxInternal vertx, String serverName) throws Exception {
        X509KeyManager mgr;
        KeyManagerFactory kmf = null;
        if (serverName != null && (mgr = this.keyCertOptions.keyManagerMapper(vertx).apply(serverName)) != null) {
            String keyStoreType = KeyStore.getDefaultType();
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            ks.load(null, null);
            ks.setKeyEntry("key", mgr.getPrivateKey(null), new char[0], mgr.getCertificateChain(null));
            String keyAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            kmf = KeyManagerFactory.getInstance(keyAlgorithm);
            kmf.init(ks, new char[0]);
        }
        if (kmf == null) {
            kmf = this.getKeyMgrFactory(vertx);
        }
        return kmf;
    }

    private KeyManagerFactory getKeyMgrFactory(VertxInternal vertx) throws Exception {
        return this.keyCertOptions == null ? null : this.keyCertOptions.getKeyManagerFactory(vertx);
    }

    private TrustManagerFactory getTrustMgrFactory(VertxInternal vertx, String serverName, boolean trustAll) throws Exception {
        TrustManager[] mgrs;
        block14: {
            block15: {
                mgrs = null;
                if (trustAll) {
                    mgrs = new TrustManager[]{SSLHelper.createTrustAllTrustManager()};
                } else if (this.trustOptions != null) {
                    if (serverName != null) {
                        TrustManagerFactory fact;
                        Function<String, TrustManager[]> mapper = this.trustOptions.trustManagerMapper(vertx);
                        if (mapper != null) {
                            mgrs = mapper.apply(serverName);
                        }
                        if (mgrs == null && (fact = this.trustOptions.getTrustManagerFactory(vertx)) != null) {
                            mgrs = fact.getTrustManagers();
                        }
                    } else {
                        TrustManagerFactory fact = this.trustOptions.getTrustManagerFactory(vertx);
                        if (fact != null) {
                            mgrs = fact.getTrustManagers();
                        }
                    }
                }
                if (mgrs == null) {
                    return null;
                }
                if (this.crlPaths == null || this.crlValues == null) break block14;
                if (this.crlPaths.size() > 0) break block15;
                if (this.crlValues.size() <= 0) break block14;
            }
            Stream<Buffer> tmp = this.crlPaths.stream().map(path -> vertx.resolveFile((String)path).getAbsolutePath()).map(vertx.fileSystem()::readFileBlocking);
            tmp = Stream.concat(tmp, this.crlValues.stream());
            CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
            ArrayList<CRL> crls = new ArrayList<CRL>();
            for (Buffer crlValue : tmp.collect(Collectors.toList())) {
                crls.addAll(certificatefactory.generateCRLs(new ByteArrayInputStream(crlValue.getBytes())));
            }
            mgrs = SSLHelper.createUntrustRevokedCertTrustManager(mgrs, crls);
        }
        return new VertxTrustManagerFactory(mgrs);
    }

    private static TrustManager[] createUntrustRevokedCertTrustManager(TrustManager[] trustMgrs, final ArrayList<CRL> crls) {
        trustMgrs = (TrustManager[])trustMgrs.clone();
        for (int i = 0; i < trustMgrs.length; ++i) {
            TrustManager trustMgr = trustMgrs[i];
            if (!(trustMgr instanceof X509TrustManager)) continue;
            final X509TrustManager x509TrustManager = (X509TrustManager)trustMgr;
            trustMgrs[i] = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    this.checkRevoked(x509Certificates);
                    x509TrustManager.checkClientTrusted(x509Certificates, s);
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    this.checkRevoked(x509Certificates);
                    x509TrustManager.checkServerTrusted(x509Certificates, s);
                }

                private void checkRevoked(X509Certificate[] x509Certificates) throws CertificateException {
                    for (X509Certificate cert : x509Certificates) {
                        for (CRL crl : crls) {
                            if (!crl.isRevoked(cert)) continue;
                            throw new CertificateException("Certificate revoked");
                        }
                    }
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return x509TrustManager.getAcceptedIssuers();
                }
            };
        }
        return trustMgrs;
    }

    private static TrustManager createTrustAllTrustManager() {
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
    }

    static {
        CLIENT_AUTH_MAPPING.put(ClientAuth.REQUIRED, io.netty.handler.ssl.ClientAuth.REQUIRE);
        CLIENT_AUTH_MAPPING.put(ClientAuth.REQUEST, io.netty.handler.ssl.ClientAuth.OPTIONAL);
        CLIENT_AUTH_MAPPING.put(ClientAuth.NONE, io.netty.handler.ssl.ClientAuth.NONE);
        log = LoggerFactory.getLogger(SSLHelper.class);
    }
}

