/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.producer.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.kafka.client.producer.KafkaHeader;
import java.util.Objects;

public class KafkaHeaderImpl
implements KafkaHeader {
    private String key;
    private Buffer value;

    public KafkaHeaderImpl(String key, Buffer value) {
        this.key = key;
        this.value = value;
    }

    public KafkaHeaderImpl(String key, String value) {
        this(key, Buffer.buffer(value));
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Buffer value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaHeaderImpl that = (KafkaHeaderImpl)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return "KafkaHeaderImpl{'" + this.key + "': " + this.value + '}';
    }
}

