/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.discovery.v1.EndpointSlice;
import io.fabric8.kubernetes.api.model.discovery.v1.EndpointSliceFluent;
import io.fabric8.kubernetes.api.model.discovery.v1.EndpointSliceFluentImpl;

public class EndpointSliceBuilder
extends EndpointSliceFluentImpl<EndpointSliceBuilder>
implements VisitableBuilder<EndpointSlice, EndpointSliceBuilder> {
    EndpointSliceFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointSliceBuilder() {
        this(false);
    }

    public EndpointSliceBuilder(Boolean validationEnabled) {
        this(new EndpointSlice(), validationEnabled);
    }

    public EndpointSliceBuilder(EndpointSliceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public EndpointSliceBuilder(EndpointSliceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EndpointSlice(), validationEnabled);
    }

    public EndpointSliceBuilder(EndpointSliceFluent<?> fluent, EndpointSlice instance) {
        this(fluent, instance, false);
    }

    public EndpointSliceBuilder(EndpointSliceFluent<?> fluent, EndpointSlice instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddressType(instance.getAddressType());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withEndpoints(instance.getEndpoints());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withPorts(instance.getPorts());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public EndpointSliceBuilder(EndpointSlice instance) {
        this(instance, (Boolean)false);
    }

    public EndpointSliceBuilder(EndpointSlice instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddressType(instance.getAddressType());
        this.withApiVersion(instance.getApiVersion());
        this.withEndpoints(instance.getEndpoints());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withPorts(instance.getPorts());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EndpointSlice build() {
        EndpointSlice buildable = new EndpointSlice(this.fluent.getAddressType(), this.fluent.getApiVersion(), this.fluent.getEndpoints(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getPorts());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

