/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;

public abstract class AbstractMappingConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = -3181156290079915301L;
    private final Function<String, String> mapping;

    public AbstractMappingConfigSourceInterceptor(Function<String, String> mapping) {
        this.mapping = mapping != null ? mapping : Function.identity();
    }

    public AbstractMappingConfigSourceInterceptor(final Map<String, String> mappings) {
        this(new Function<String, String>(){

            @Override
            public String apply(String name) {
                return mappings.getOrDefault(name, name);
            }
        });
    }

    @Override
    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet<String> names = new HashSet<String>();
        Iterator<String> namesIterator = context.iterateNames();
        while (namesIterator.hasNext()) {
            String name = namesIterator.next();
            names.add(name);
            String mappedName = this.mapping.apply(name);
            if (mappedName == null) continue;
            names.add(mappedName);
        }
        return names.iterator();
    }

    @Override
    public Iterator<ConfigValue> iterateValues(ConfigSourceInterceptorContext context) {
        HashSet<ConfigValue> values = new HashSet<ConfigValue>();
        Iterator<ConfigValue> valuesIterator = context.iterateValues();
        while (valuesIterator.hasNext()) {
            ConfigValue value = valuesIterator.next();
            values.add(value);
            String mappedName = this.mapping.apply(value.getName());
            if (mappedName == null) continue;
            values.add(ConfigValue.builder().withName(mappedName).withValue(value.getValue()).withRawValue(value.getRawValue()).withProfile(value.getProfile()).withConfigSourceName(value.getConfigSourceName()).withConfigSourcePosition(value.getConfigSourcePosition()).withConfigSourceOrdinal(value.getConfigSourceOrdinal()).withLineNumber(value.getLineNumber()).build());
        }
        return values.iterator();
    }

    protected Function<String, String> getMapping() {
        return this.mapping;
    }
}

