/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.picocli.runtime;

import io.quarkus.runtime.QuarkusApplication;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.Event;
import picocli.CommandLine;

@Dependent
public class PicocliRunner
implements QuarkusApplication {
    private final CommandLine commandLine;

    public PicocliRunner(CommandLine commandLine, Event<CommandLine.ParseResult> parseResultEvent) {
        this.commandLine = commandLine.setExecutionStrategy(new EventExecutionStrategy(commandLine.getExecutionStrategy(), parseResultEvent));
    }

    @Override
    public int run(String ... args) throws Exception {
        try {
            int n = this.commandLine.execute(args);
            return n;
        }
        finally {
            this.commandLine.getOut().flush();
            this.commandLine.getErr().flush();
        }
    }

    private static final class EventExecutionStrategy
    implements CommandLine.IExecutionStrategy {
        private final CommandLine.IExecutionStrategy executionStrategy;
        private final Event<CommandLine.ParseResult> parseResultEvent;

        private EventExecutionStrategy(CommandLine.IExecutionStrategy executionStrategy, Event<CommandLine.ParseResult> parseResultEvent) {
            this.executionStrategy = executionStrategy;
            this.parseResultEvent = parseResultEvent;
        }

        @Override
        public int execute(CommandLine.ParseResult parseResult) throws CommandLine.ExecutionException, CommandLine.ParameterException {
            this.parseResultEvent.fire(parseResult);
            return this.executionStrategy.execute(parseResult);
        }
    }
}

