/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.FormLoginHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;

public class FormLoginHandlerImpl
extends AuthenticationHandlerImpl<AuthenticationProvider>
implements FormLoginHandler {
    private String usernameParam;
    private String passwordParam;
    private String returnURLParam;
    private String directLoggedInOKURL;
    private static final String DEFAULT_DIRECT_LOGGED_IN_OK_PAGE = "<html><body><h1>Login successful</h1></body></html>";

    @Override
    public FormLoginHandler setUsernameParam(String usernameParam) {
        this.usernameParam = usernameParam;
        return this;
    }

    @Override
    public FormLoginHandler setPasswordParam(String passwordParam) {
        this.passwordParam = passwordParam;
        return this;
    }

    @Override
    public FormLoginHandler setReturnURLParam(String returnURLParam) {
        this.returnURLParam = returnURLParam;
        return this;
    }

    @Override
    public FormLoginHandler setDirectLoggedInOKURL(String directLoggedInOKURL) {
        this.directLoggedInOKURL = directLoggedInOKURL;
        return this;
    }

    public FormLoginHandlerImpl(AuthenticationProvider authProvider, String usernameParam, String passwordParam, String returnURLParam, String directLoggedInOKURL) {
        super(authProvider);
        this.usernameParam = usernameParam;
        this.passwordParam = passwordParam;
        this.returnURLParam = returnURLParam;
        this.directLoggedInOKURL = directLoggedInOKURL;
    }

    @Override
    public void authenticate(RoutingContext context, Handler<AsyncResult<User>> handler) {
        HttpServerRequest req = context.request();
        if (req.method() != HttpMethod.POST) {
            handler.handle(Future.failedFuture(BAD_METHOD));
        } else if (!context.body().available()) {
            handler.handle(Future.failedFuture("BodyHandler is required to process POST requests"));
        } else {
            MultiMap params = req.formAttributes();
            String username = params.get(this.usernameParam);
            String password = params.get(this.passwordParam);
            if (username == null || password == null) {
                handler.handle(Future.failedFuture(BAD_REQUEST));
            } else {
                this.authProvider.authenticate(new UsernamePasswordCredentials(username, password), (AsyncResult<User> authn) -> {
                    if (authn.failed()) {
                        handler.handle(Future.failedFuture(new HttpException(401, authn.cause())));
                    } else {
                        handler.handle((AsyncResult<User>)authn);
                    }
                });
            }
        }
    }

    @Override
    public void postAuthentication(RoutingContext ctx) {
        String returnURL;
        HttpServerRequest req = ctx.request();
        Session session = ctx.session();
        if (session != null && (returnURL = (String)session.remove(this.returnURLParam)) != null) {
            ctx.redirect(returnURL);
            return;
        }
        if (this.directLoggedInOKURL != null) {
            ctx.redirect(this.directLoggedInOKURL);
        } else {
            req.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html; charset=utf-8").end(DEFAULT_DIRECT_LOGGED_IN_OK_PAGE);
        }
    }
}

