/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.mylyn.docs.intent.client.ui.IntentEditorActivator;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentDocumentProvider;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorDocument;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotation;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractIntentFix
implements ICompletionProposal {
    protected IntentAnnotation syncAnnotation;

    public AbstractIntentFix(IntentAnnotation annotation) {
        if (!(annotation instanceof IntentAnnotation)) {
            throw new IllegalArgumentException("Cannot apply an Intent fix on the given annotation: should be an IntentAnnotation " + ((Object)((Object)annotation)).toString());
        }
        this.syncAnnotation = annotation;
    }

    public final void apply(IDocument document) {
        if (!(document instanceof IntentEditorDocument)) {
            throw new IllegalArgumentException("Cannot apply an Intent fix on the given document: should be an IntentEditorDocument " + document.toString());
        }
        IntentEditorDocument intentEditorDocument = (IntentEditorDocument)document;
        IntentEditor editor = intentEditorDocument.getIntentEditor();
        IntentDocumentProvider documentProvider = (IntentDocumentProvider)editor.getDocumentProvider();
        RepositoryAdapter repositoryAdapter = documentProvider.getListenedElementsHandler().getRepositoryAdapter();
        this.applyFix(repositoryAdapter, intentEditorDocument);
    }

    protected abstract void applyFix(RepositoryAdapter var1, IntentEditorDocument var2);

    public final Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return "";
    }

    public Image getImage() {
        return IntentEditorActivator.getDefault().getImage("icon/annotation/sync-warning.gif");
    }

    public final IContextInformation getContextInformation() {
        return null;
    }
}

