/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.exporter.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.docs.intent.client.ui.logger.IntentUiLogger;
import org.eclipse.mylyn.docs.intent.collab.common.repository.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.exporter.main.HTMLBootstrapGenDocument;
import org.osgi.framework.Bundle;

public class IntentHTMLExporter {
    public void exportIntentDocumentation(IntentStructuredElement intentElement, String targetFolderLocation, String projectName, Monitor progressMonitor) {
        try {
            Repository repository = IntentRepositoryManager.INSTANCE.getRepository(EcoreUtil.getURI((EObject)intentElement).toString());
            RepositoryAdapter repositoryAdapter = repository.createRepositoryAdapter();
            repositoryAdapter.openSaveContext();
            File targetFolder = new File(targetFolderLocation);
            if (!targetFolder.exists()) {
                targetFolder.mkdirs();
            }
            this.copyRequiredResourcesToGenerationFolder(targetFolder);
            HTMLBootstrapGenDocument generator = new HTMLBootstrapGenDocument((EObject)intentElement, targetFolder, new ArrayList());
            generator.doGenerate(progressMonitor, projectName, repositoryAdapter);
            repositoryAdapter.closeContext();
        }
        catch (IOException e) {
            IntentUiLogger.logError((Throwable)e);
        }
        catch (CoreException e) {
            IntentUiLogger.logError((Throwable)e);
        }
        catch (RepositoryConnectionException e) {
            IntentUiLogger.logError((Throwable)e);
        }
        catch (ReadOnlyException e) {
            IntentUiLogger.logError((Throwable)e);
        }
    }

    private void copyRequiredResourcesToGenerationFolder(File targetFolder) throws IOException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.mylyn.docs.intent.exporter");
        Path path = new Path("resources/html_bootstrap/html_bootstrap.zip");
        ZipInputStream zipFileStream = new ZipInputStream(FileLocator.find((Bundle)bundle, (IPath)path, null).openStream());
        ZipEntry zipEntry = zipFileStream.getNextEntry();
        try {
            while (zipEntry != null) {
                File file = new File(targetFolder.getAbsolutePath().toString(), zipEntry.getName());
                if (!zipEntry.isDirectory()) {
                    File parentFile = file.getParentFile();
                    if (parentFile != null && !parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    FileOutputStream os = null;
                    try {
                        os = new FileOutputStream(file);
                        byte[] buffer = new byte[102400];
                        while (true) {
                            int len = zipFileStream.read(buffer);
                            if (zipFileStream.available() == 0) {
                                break;
                            }
                            ((OutputStream)os).write(buffer, 0, len);
                        }
                    }
                    finally {
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                    }
                }
                zipFileStream.closeEntry();
                zipEntry = zipFileStream.getNextEntry();
            }
        }
        finally {
            zipFileStream.close();
        }
    }
}

