/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.common.internal.repository.contribution;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.eclipse.mylyn.docs.intent.collab.common.internal.repository.contribution.IntentRepositoryManagerContributionDescriptor;
import org.eclipse.mylyn.docs.intent.collab.common.repository.contribution.IntentRepositoryManagerContribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntentRepositoryManagerContributionRegistry {
    private static final Map<IntentRepositoryManagerContributionDescriptor, IntentRepositoryManagerContribution> DECLARED_CONTRIBUTIONS = Maps.newLinkedHashMap();

    private IntentRepositoryManagerContributionRegistry() {
    }

    public static Collection<IntentRepositoryManagerContribution> getRepositoryManagerContributions() {
        for (Map.Entry<IntentRepositoryManagerContributionDescriptor, IntentRepositoryManagerContribution> descriptorToContribution : DECLARED_CONTRIBUTIONS.entrySet()) {
            if (descriptorToContribution.getValue() != null) continue;
            descriptorToContribution.setValue(descriptorToContribution.getKey().createRepositoryManagerContribution());
        }
        return DECLARED_CONTRIBUTIONS.values();
    }

    public static void addRepositoryManagerContribution(IntentRepositoryManagerContributionDescriptor descriptor) {
        DECLARED_CONTRIBUTIONS.put(descriptor, null);
    }

    public static void removeExtension(String extensionClassName) {
        for (IntentRepositoryManagerContributionDescriptor extension : DECLARED_CONTRIBUTIONS.keySet()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            DECLARED_CONTRIBUTIONS.remove(extension);
        }
    }

    public static void clearContributedRepositoryManagerContributions() {
        DECLARED_CONTRIBUTIONS.clear();
    }
}

