/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.completion;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.mylyn.docs.intent.client.ui.editor.completion.AbstractIntentCompletionProcessor;
import org.eclipse.mylyn.docs.intent.collab.common.query.TraceabilityInformationsQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelingUnitCompletionProcessor
extends AbstractIntentCompletionProcessor {
    private static final String RIGHT_PAR = ")";
    private static final String DOT = ".";
    private static final String NEW_LINE = "\n\t";
    private static final String NEW_ENTITY_KEYWORD = "new";
    private static final String RESOURCE_DECLARATION_KEYWORD = "Resource";
    private static final String REF_KEYWORD = "@ref";
    private static final String MODELINGUNIT_NEW_ELEMENT_ICON = "icon/outline/modelingunit_new_element.png";
    private static final String MODELINGUNIT_RESOURCE_ICON = "icon/outline/modelingunit_resource.gif";
    private static final String IDENTIFIER_REGEXP = "([a-zA-z0-9_-]+)";
    private static final String QUALIFIED_NAME_DELIMITER = "\\.";
    private TraceabilityInformationsQuery traceabilityInfoQuery;
    private RepositoryAdapter repositoryAdapter;

    public ModelingUnitCompletionProcessor(RepositoryAdapter repositoryAdapter) {
        this.repositoryAdapter = repositoryAdapter;
    }

    @Override
    protected ICompletionProposal[] computeCompletionProposals() {
        this.traceabilityInfoQuery = new TraceabilityInformationsQuery(this.repositoryAdapter);
        LinkedHashSet proposals = Sets.newLinkedHashSet();
        try {
            String text = this.document.get(0, this.offset);
            int startOffset = this.getLastIndexOf(text, Pattern.compile("@M"));
            if (startOffset > -1) {
                text = text.substring(startOffset);
            }
            String intialText = text;
            text = this.removeInstructionsInsideClosedBrackets(text);
            String lastRelevantKeyWord = this.getLastRelevantKeyWord(text = this.removeEndedInstructions(text));
            if (lastRelevantKeyWord == null) {
                proposals.addAll(this.getProposalsForEmptyModelingUnit("".equals(intialText), ""));
            } else {
                proposals.addAll(this.computeCompletionProposalsFromText(text, lastRelevantKeyWord));
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (ReadOnlyException readOnlyException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (proposals.isEmpty()) {
            proposals.add(this.createTemplateProposal("", "No completion available", "", "icon/outline/default.gif"));
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private Collection<ICompletionProposal> computeCompletionProposalsFromText(String text, String lastRelevantKeyWord) throws ReadOnlyException {
        LinkedHashSet proposals = Sets.newLinkedHashSet();
        if ("".equals(lastRelevantKeyWord)) {
            proposals.addAll(this.getProposalsForEmptyModelingUnit(false, text.trim()));
        } else if (NEW_ENTITY_KEYWORD.equals(lastRelevantKeyWord)) {
            proposals.addAll(this.getProposalsForNewInstruction(text));
        } else if ("{".equals(lastRelevantKeyWord)) {
            proposals.addAll(this.getProposalsForStructuralFeatureAffectation(text));
        } else if ("=".equals(lastRelevantKeyWord) || "+=".equals(lastRelevantKeyWord)) {
            proposals.addAll(this.getProposalsForStructuralFeatureValue(text));
        }
        return proposals;
    }

    private Collection<? extends ICompletionProposal> getProposalsForEmptyModelingUnit(boolean isAtMUBeggining, String text) throws ReadOnlyException {
        LinkedHashSet proposals = Sets.newLinkedHashSet();
        String prefix = NEW_LINE;
        if (isAtMUBeggining) {
            prefix = "@M\n\t";
        }
        if (text.length() == 0 || RESOURCE_DECLARATION_KEYWORD.startsWith(text)) {
            proposals.add(this.createResourceDeclarationProposal(prefix));
        }
        if (text.length() == 0 || NEW_ENTITY_KEYWORD.startsWith(text)) {
            proposals.add(this.createNewEntityProposal(prefix));
        }
        if (text.length() == 0 || REF_KEYWORD.startsWith(text)) {
            proposals.add(this.createNewInternalRefProposal(prefix));
        }
        for (InstanciationInstruction instruction : this.traceabilityInfoQuery.getInstanciations()) {
            if (instruction.getName() == null || text.length() != 0 && !instruction.getName().startsWith(text)) continue;
            String description = "Contribute to the " + instruction.getName() + " ";
            description = instruction.getMetaType() != null && instruction.getMetaType().getTypeName() != null ? String.valueOf(description) + instruction.getMetaType().getTypeName() : String.valueOf(description) + "entity";
            proposals.add(this.createTemplateProposal(String.valueOf(instruction.getName()) + " (contribution)", description, String.valueOf(prefix) + instruction.getName() + " {\n\t\t${}\n\t}", "icon/outline/modelingunit_contribution.png"));
        }
        return proposals;
    }

    private Collection<? extends ICompletionProposal> getProposalsForNewInstruction(String text) throws ReadOnlyException {
        String classNameBeginning = text.substring(text.lastIndexOf(NEW_ENTITY_KEYWORD)).replace(NEW_ENTITY_KEYWORD, "").trim();
        return this.getProposalsForEClassifier(classNameBeginning);
    }

    private Collection<ICompletionProposal> getProposalsForStructuralFeatureAffectation(String text) throws ReadOnlyException {
        LinkedHashSet proposals = Sets.newLinkedHashSet();
        String contributionName = "";
        String featureNameBeginning = "";
        boolean isContribution = true;
        boolean isResourceDeclaration = false;
        if (text.lastIndexOf("{") != -1) {
            contributionName = text.substring(0, text.lastIndexOf("{")).trim();
            if (contributionName.contains("\n")) {
                String[] split = contributionName.split("\n");
                contributionName = split[split.length - 1].trim();
            }
            featureNameBeginning = text.substring(text.lastIndexOf("{")).replace("{", "").trim();
            if (contributionName.contains(NEW_ENTITY_KEYWORD)) {
                isContribution = false;
                contributionName = contributionName.substring(contributionName.lastIndexOf(NEW_ENTITY_KEYWORD)).trim();
                if ((contributionName = contributionName.substring(contributionName.indexOf(" ")).trim()).contains(" ")) {
                    contributionName = contributionName.substring(0, contributionName.indexOf(" ")).trim();
                }
            }
            if (contributionName.contains(RESOURCE_DECLARATION_KEYWORD)) {
                isResourceDeclaration = true;
                isContribution = false;
            }
        }
        if (isContribution) {
            this.getProposalsForContribution(proposals, contributionName, featureNameBeginning);
        } else if (isResourceDeclaration) {
            this.getProposalsForResourceDeclaration(proposals);
        } else {
            EClassifier classifierToConsider = this.getEClassifier(contributionName);
            if (classifierToConsider instanceof EClass) {
                for (EStructuralFeature feature : ((EClass)classifierToConsider).getEAllStructuralFeatures()) {
                    if (!this.isSettableFeature(feature) || featureNameBeginning.length() != 0 && !feature.getName().startsWith(featureNameBeginning)) continue;
                    proposals.add(this.createStructuralFeatureAffectationTemplateProposal(contributionName, feature));
                }
            }
        }
        return proposals;
    }

    private void getProposalsForResourceDeclaration(Collection<ICompletionProposal> proposals) {
        proposals.add((ICompletionProposal)this.createTemplateProposal("Resource URI", "URI indicating the Resource location", "URI = \"${}\";", MODELINGUNIT_RESOURCE_ICON));
        proposals.add((ICompletionProposal)this.createTemplateProposal("Resource Content", "Add content to the Resource", "content += ${};", MODELINGUNIT_RESOURCE_ICON));
    }

    private void getProposalsForContribution(Collection<ICompletionProposal> proposals, String contributionName, String featureNameBeginning) throws ReadOnlyException {
        for (InstanciationInstruction instruction : this.traceabilityInfoQuery.getInstanciations()) {
            if (!contributionName.equals(instruction.getName()) || instruction.getMetaType() == null || instruction.getMetaType().getResolvedType() == null) continue;
            for (EStructuralFeature feature : instruction.getMetaType().getResolvedType().getEAllStructuralFeatures()) {
                if (!this.isSettableFeature(feature) || featureNameBeginning.length() != 0 && !feature.getName().startsWith(featureNameBeginning)) continue;
                proposals.add((ICompletionProposal)this.createStructuralFeatureAffectationTemplateProposal(contributionName, feature));
            }
        }
    }

    private Collection<? extends ICompletionProposal> getProposalsForStructuralFeatureValue(String text) throws ReadOnlyException {
        LinkedHashSet proposals = Sets.newLinkedHashSet();
        boolean isContribution = true;
        boolean isResourceContribution = false;
        EClassifier classifierToConsider = null;
        String classifierName = null;
        String featureName = null;
        String beginning = "";
        if (text.lastIndexOf("{") != -1) {
            classifierName = text.substring(0, text.lastIndexOf("{")).trim();
            featureName = text.substring(text.lastIndexOf("{")).replace("{", "").trim();
            if (featureName.contains("+=")) {
                beginning = featureName.substring(featureName.indexOf("+=") + 2).trim();
                featureName = featureName.substring(0, featureName.indexOf("+=")).trim();
            } else if (featureName.contains("=")) {
                beginning = featureName.substring(featureName.indexOf("=") + 1).trim();
                featureName = featureName.substring(0, featureName.indexOf("=")).trim();
            }
            if (classifierName.contains(NEW_ENTITY_KEYWORD)) {
                isContribution = false;
                classifierName = classifierName.substring(classifierName.lastIndexOf(NEW_ENTITY_KEYWORD)).trim();
                if ((classifierName = classifierName.substring(classifierName.indexOf(" ")).trim()).contains(" ")) {
                    classifierName = classifierName.substring(0, classifierName.indexOf(" ")).trim();
                }
            }
            if (classifierName.contains(RESOURCE_DECLARATION_KEYWORD)) {
                isContribution = false;
                isResourceContribution = true;
                featureName = "Resource Content";
            }
        }
        if (isContribution) {
            for (InstanciationInstruction instruction : this.traceabilityInfoQuery.getInstanciations()) {
                if (!classifierName.equals(instruction.getName()) || instruction.getMetaType() == null || instruction.getMetaType().getResolvedType() == null) continue;
                classifierToConsider = instruction.getMetaType().getResolvedType();
                break;
            }
        } else if (!isResourceContribution) {
            classifierToConsider = this.getEClassifier(classifierName);
        }
        if (isResourceContribution || classifierToConsider instanceof EClass) {
            EStructuralFeature featureToConsider = null;
            if (!isResourceContribution) {
                featureToConsider = ((EClass)classifierToConsider).getEStructuralFeature(featureName);
            }
            if (isResourceContribution || featureToConsider != null && featureToConsider.getEType() != null && featureToConsider.getEType().getName() != null) {
                proposals.addAll(this.doGetProposalsForStructuralFeatureValue(isResourceContribution, featureName, beginning, featureToConsider));
            }
        }
        return proposals;
    }

    private Collection<ICompletionProposal> doGetProposalsForStructuralFeatureValue(boolean isResourceContribution, String featureName, String beginning, EStructuralFeature featureToConsider) throws ReadOnlyException {
        LinkedHashSet proposals = Sets.newLinkedHashSet();
        if (featureToConsider instanceof EAttribute) {
            String defaultAttributeValue = "";
            if (featureToConsider.getEType().getDefaultValue() != null) {
                defaultAttributeValue = "Default: " + featureToConsider.getDefaultValue().toString();
            }
            if (featureToConsider.getEType() instanceof EEnum) {
                for (EEnumLiteral literal : ((EEnum)featureToConsider.getEType()).getELiterals()) {
                    proposals.add(this.createTemplateProposal("'" + literal.getName() + "' value (of type " + featureToConsider.getEType().getName() + RIGHT_PAR, String.valueOf(defaultAttributeValue) + " - Set a simple value of type " + featureToConsider.getEType().getName(), String.valueOf('\"') + literal.getName() + "\";", "icon/outline/modelingunit_value.gif"));
                }
            } else {
                proposals.add(this.createTemplateProposal("value (of type " + featureToConsider.getEType().getName() + RIGHT_PAR, String.valueOf(defaultAttributeValue) + " - Set a simple value of type " + featureToConsider.getEType().getName(), String.valueOf('\"') + defaultAttributeValue + "\";", "icon/outline/modelingunit_value.gif"));
            }
        } else {
            if (!isResourceContribution) {
                proposals.add(this.createTemplateProposal("new Element (of type " + featureToConsider.getEType().getName() + RIGHT_PAR, "Set this new Element as value for " + featureToConsider.getName(), "new " + ModelingUnitCompletionProcessor.getQualifiedName(featureToConsider.getEType().getEPackage()) + DOT + featureToConsider.getEType().getName() + "{\n\t${}\n};", MODELINGUNIT_NEW_ELEMENT_ICON));
            }
            for (InstanciationInstruction instruction : this.traceabilityInfoQuery.getInstanciations()) {
                boolean hasMatchingName;
                boolean isMatchingInstruction = false;
                boolean bl = hasMatchingName = instruction.getName() != null && (beginning.length() == 0 || instruction.getName().startsWith(beginning));
                if (hasMatchingName && !isResourceContribution) {
                    isMatchingInstruction = instruction.getMetaType() != null && (featureToConsider.getEType().equals(instruction.getMetaType().getResolvedType()) || featureToConsider.getEType() instanceof EClass && ((EClass)featureToConsider.getEType()).isSuperTypeOf(instruction.getMetaType().getResolvedType()));
                } else if (hasMatchingName) {
                    isMatchingInstruction = true;
                }
                if (!isMatchingInstruction) continue;
                proposals.add(this.createTemplateProposal("Reference to " + instruction.getName(), "Set the " + instruction.getName() + " element as value for " + featureName, instruction.getName(), "icon/outline/modelingunit_ref.png"));
            }
            if (!isResourceContribution && featureToConsider.getEType().equals(EcorePackage.eINSTANCE.getEClassifier())) {
                proposals.addAll(this.getProposalsForEClassifier(beginning));
            }
        }
        return proposals;
    }

    private Collection<? extends ICompletionProposal> getProposalsForEClassifier(String classNameBeginning) throws ReadOnlyException {
        boolean isPrefixedByPackageName = classNameBeginning.indexOf(46) != -1;
        String packageNamePrefix = null;
        String classNameBeginningWithoutPackageDeclaration = classNameBeginning;
        if (isPrefixedByPackageName) {
            String[] split = classNameBeginning.split(QUALIFIED_NAME_DELIMITER);
            packageNamePrefix = split[0];
            classNameBeginningWithoutPackageDeclaration = split.length == 1 ? "" : split[1];
        }
        LinkedHashSet proposals = Sets.newLinkedHashSet();
        Iterator availablePackages = Iterables.filter((Iterable)this.traceabilityInfoQuery.getOrCreateTraceabilityIndex().eResource().getResourceSet().getPackageRegistry().values(), EPackage.class).iterator();
        int i = 0;
        while (availablePackages.hasNext() && i < 100) {
            EPackage availablePackage = (EPackage)availablePackages.next();
            if (isPrefixedByPackageName && (!isPrefixedByPackageName || !ModelingUnitCompletionProcessor.getQualifiedName(availablePackage).equals(packageNamePrefix))) continue;
            for (EClassifier availableClass : availablePackage.getEClassifiers()) {
                if (availableClass.getName() == null || classNameBeginningWithoutPackageDeclaration.length() != 0 && !availableClass.getName().startsWith(classNameBeginningWithoutPackageDeclaration)) continue;
                String proposalContent = availableClass.getName();
                if (!isPrefixedByPackageName) {
                    proposalContent = String.valueOf(ModelingUnitCompletionProcessor.getQualifiedName(availablePackage)) + DOT + proposalContent;
                }
                proposals.add(this.createTemplateProposal(availableClass.getName(), availablePackage.getNsURI(), proposalContent, MODELINGUNIT_NEW_ELEMENT_ICON));
                ++i;
            }
        }
        return proposals;
    }

    private String getLastRelevantKeyWord(String text) {
        String lastRelevantKeyword = null;
        int lastNew = this.getLastIndexOf(text, Pattern.compile(NEW_ENTITY_KEYWORD));
        int lastOpeningBracket = text.lastIndexOf("{");
        int lastStructuralFeatureAffectation = text.lastIndexOf("=");
        int lastMultiValuedStructuralFeatureAffectation = text.lastIndexOf("+=");
        int lastKWIndex = Math.max(Math.max(lastStructuralFeatureAffectation, lastStructuralFeatureAffectation), Math.max(lastNew, lastOpeningBracket));
        if (lastKWIndex != -1) {
            if (lastKWIndex == lastNew) {
                lastRelevantKeyword = NEW_ENTITY_KEYWORD;
            } else if (lastKWIndex == lastOpeningBracket) {
                lastRelevantKeyword = "{";
            } else if (lastKWIndex == lastStructuralFeatureAffectation) {
                lastRelevantKeyword = "=";
            } else if (lastKWIndex == lastMultiValuedStructuralFeatureAffectation) {
                lastRelevantKeyword = "+=";
            }
        }
        return lastRelevantKeyword;
    }

    private String removeInstructionsInsideClosedBrackets(String text) {
        String textWithClosedInstructionsRemoved = text;
        try {
            int nextOffsetForEndingInstruction = textWithClosedInstructionsRemoved.indexOf("}");
            int nextOffsetForEndingInstruction2 = textWithClosedInstructionsRemoved.indexOf("};");
            while (Math.max(nextOffsetForEndingInstruction, nextOffsetForEndingInstruction2) != -1) {
                String textToRemove = "";
                textToRemove = nextOffsetForEndingInstruction > nextOffsetForEndingInstruction2 ? textWithClosedInstructionsRemoved.substring(0, nextOffsetForEndingInstruction + 1) : textWithClosedInstructionsRemoved.substring(0, nextOffsetForEndingInstruction + 2);
                textToRemove = textToRemove.substring(textToRemove.substring(0, textToRemove.lastIndexOf("{")).lastIndexOf("\n"));
                textWithClosedInstructionsRemoved = textWithClosedInstructionsRemoved.replace(textToRemove, "");
                nextOffsetForEndingInstruction = textWithClosedInstructionsRemoved.indexOf("}");
                nextOffsetForEndingInstruction2 = textWithClosedInstructionsRemoved.indexOf("};");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        return textWithClosedInstructionsRemoved;
    }

    private String removeEndedInstructions(String text) {
        Document tempDoc = new Document(text);
        try {
            while (tempDoc.get().lastIndexOf(";") > -1) {
                int lineToRemove = tempDoc.getLineOfOffset(tempDoc.get().lastIndexOf(";"));
                int lineToRemoveOffset = tempDoc.getLineOffset(lineToRemove);
                int lineToRemoveLength = tempDoc.getLineLength(lineToRemove);
                String newDocContent = String.valueOf(tempDoc.get().substring(0, lineToRemoveOffset)) + tempDoc.get().substring(lineToRemoveOffset + lineToRemoveLength);
                tempDoc.set(newDocContent);
            }
        }
        catch (BadLocationException badLocationException) {}
        return tempDoc.get();
    }

    private TemplateProposal createStructuralFeatureAffectationTemplateProposal(String contributionName, EStructuralFeature feature) {
        String affect = "=";
        if (feature.isMany()) {
            affect = "+" + affect;
        }
        String label = feature.getName();
        if (feature.getEType() != null && feature.getEType().getName() != null) {
            label = String.valueOf(label) + " : " + feature.getEType().getName();
            if (feature.getLowerBound() != 1 || feature.getUpperBound() != 1) {
                label = String.valueOf(label) + " [";
                label = feature.getLowerBound() == 0 && feature.getUpperBound() == 1 ? String.valueOf(label) + "?" : (feature.getUpperBound() != -1 ? String.valueOf(label) + feature.getLowerBound() + "," + feature.getUpperBound() : String.valueOf(label) + feature.getLowerBound() + ",*");
                label = String.valueOf(label) + "]";
            }
        }
        String description = "Set the value " + contributionName + DOT + feature.getName();
        if (feature.getDefaultValue() != null) {
            description = "Default: " + feature.getDefaultValue() + " - " + description;
        }
        return this.createTemplateProposal(label, description, String.valueOf(feature.getName()) + " " + affect + " ", "icon/outline/modelingunit_affect.png");
    }

    private EClassifier getEClassifier(String contributionName) throws ReadOnlyException {
        EClassifier classifierToConsider = null;
        Iterator availablePackages = Iterables.filter((Iterable)this.traceabilityInfoQuery.getOrCreateTraceabilityIndex().eResource().getResourceSet().getPackageRegistry().values(), EPackage.class).iterator();
        String packageName = null;
        String classifierName = contributionName;
        if (contributionName.matches("([a-zA-z0-9_-]+)\\.([a-zA-z0-9_-]+)")) {
            String[] split = contributionName.split(QUALIFIED_NAME_DELIMITER);
            packageName = split[0];
            classifierName = split[1];
        }
        while (availablePackages.hasNext() && classifierToConsider == null) {
            EPackage availablePackage = (EPackage)availablePackages.next();
            if (packageName != null && !packageName.equals(availablePackage.getName())) continue;
            classifierToConsider = availablePackage.getEClassifier(classifierName);
        }
        return classifierToConsider;
    }

    private boolean isSettableFeature(EStructuralFeature feature) {
        return feature.isChangeable() && !feature.isDerived();
    }

    private static String getQualifiedName(EPackage ePackage) {
        String res = ePackage.getName();
        EPackage tmp = (EPackage)ePackage.eContainer();
        while (tmp != null) {
            res = String.valueOf(tmp.getName()) + '.' + res;
            tmp = (EPackage)tmp.eContainer();
        }
        return res;
    }

    private ICompletionProposal createNewEntityProposal(String prefix) {
        return this.createTemplateProposal(NEW_ENTITY_KEYWORD, "Declaration of a new entity", String.valueOf(prefix) + "new ${Type} {}", MODELINGUNIT_NEW_ELEMENT_ICON);
    }

    private ICompletionProposal createResourceDeclarationProposal(String prefix) {
        return this.createTemplateProposal(RESOURCE_DECLARATION_KEYWORD, "Declaration of a new Resource", String.valueOf(prefix) + "Resource myResource {\n\t\tURI = \"${}\";\n\t}", MODELINGUNIT_RESOURCE_ICON);
    }

    private ICompletionProposal createNewInternalRefProposal(String prefix) {
        return this.createTemplateProposal(REF_KEYWORD, "Declaration of a new internal entity (stored only inside the intent repository)", String.valueOf(prefix) + REF_KEYWORD + " \"intent:/" + this.repositoryAdapter.getRepository().getIdentifier() + "/${newElementPath}\"", MODELINGUNIT_NEW_ELEMENT_ICON);
    }

    @Override
    public String getContextType() {
        return "__Intent__modelingunit";
    }
}

