/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.ide.notification;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.Notificator;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotification;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotificationFactoryHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceTypeListener {
    private final Notificator typeNotificator;
    private final Set<EStructuralFeature> listenedTypes;

    public WorkspaceTypeListener(Notificator typeNotificator, Set<EStructuralFeature> typesToListen) {
        this.typeNotificator = typeNotificator;
        this.listenedTypes = new LinkedHashSet<EStructuralFeature>();
        this.listenedTypes.addAll(typesToListen);
    }

    public void notifyResourceChanged(Resource resource) {
        RepositoryChangeNotification newNotification;
        boolean changesDetected = false;
        Iterator contentIterator = Sets.newLinkedHashSet((Iterable)resource.getContents()).iterator();
        while (contentIterator.hasNext() && !changesDetected) {
            EObject nextRoot = (EObject)contentIterator.next();
            Iterator rootFeaturesIterator = nextRoot.eClass().getEAllStructuralFeatures().iterator();
            while (rootFeaturesIterator.hasNext() && !changesDetected) {
                EStructuralFeature next = (EStructuralFeature)rootFeaturesIterator.next();
                changesDetected = this.isListenedTypeModification(next);
            }
        }
        if (changesDetected && (newNotification = RepositoryChangeNotificationFactoryHolder.getChangeNotificationFactory().createRepositoryChangeNotification((Object)resource)) != null) {
            this.typeNotificator.notifyHandlers(newNotification);
        }
    }

    private boolean isListenedTypeModification(EStructuralFeature feature) {
        boolean isListenedType = false;
        Iterator<EStructuralFeature> iterator = this.listenedTypes.iterator();
        while (iterator.hasNext() && !isListenedType) {
            ENamedElement listenedtype = (ENamedElement)iterator.next();
            if (listenedtype instanceof EStructuralFeature) {
                isListenedType = listenedtype.equals(feature);
            }
            if (!(listenedtype instanceof EClass)) continue;
            isListenedType = ((EClass)listenedtype).getEAllStructuralFeatures().contains((Object)feature);
        }
        return isListenedType;
    }
}

