/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.parser.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusSeverity;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerFactory;
import org.eclipse.mylyn.docs.intent.core.document.IntentChapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocumentFactory;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.parser.internal.state.IntentGenericState;
import org.eclipse.mylyn.docs.intent.parser.internal.state.SChapter;
import org.eclipse.mylyn.docs.intent.parser.internal.state.SDocument;
import org.eclipse.mylyn.docs.intent.parser.internal.state.SSection;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.ParseException;
import org.eclipse.mylyn.docs.intent.serializer.IntentPositionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentBuilder {
    private IntentPositionManager positionManager;
    private EObject currentRoot;
    private List<EObject> roots = new ArrayList<EObject>();
    private IntentGenericState currentState;
    private int currentImbricationLevel;
    private String rootCompleteLevel;

    public IntentBuilder(IntentPositionManager positionManager, String rootCompleteLevel) {
        this.positionManager = positionManager;
        this.rootCompleteLevel = rootCompleteLevel;
    }

    public List<EObject> getRoots() {
        return this.roots;
    }

    public EObject getRoot() throws ParseException {
        if (this.roots.size() != 1) {
            throw new ParseException("The elements described should be enclosed in a super element. ");
        }
        if (this.currentImbricationLevel > 0) {
            this.addStatusOnElement(this.roots.get(0), "Syntax error : insert \"}\" to close this element.");
        }
        return this.roots.get(0);
    }

    public void increaseImbricationLevel() {
        ++this.currentImbricationLevel;
    }

    public void decreaseImbricationLevel() {
        --this.currentImbricationLevel;
    }

    public void beginDocument(int offset, int declarationLength) throws ParseException {
        if (this.currentState != null) {
            throw new ParseException("Can't open any document here.", offset, declarationLength);
        }
        this.currentRoot = IntentDocumentFactory.eINSTANCE.createIntentDocument();
        this.roots.add(this.currentRoot);
        this.currentState = new SDocument(offset, declarationLength, null, (IntentDocument)this.currentRoot, this.positionManager);
        this.increaseImbricationLevel();
    }

    public void beginChapter(int offset, int declarationLength, String title) throws ParseException {
        this.increaseImbricationLevel();
        if (this.currentState == null) {
            this.currentRoot = IntentDocumentFactory.eINSTANCE.createIntentChapter();
            this.roots.add(this.currentRoot);
            this.currentState = new SChapter(offset, declarationLength, null, (IntentChapter)this.currentRoot, this.positionManager, title, this.rootCompleteLevel);
        } else {
            this.currentState = this.currentState.beginChapter(offset, declarationLength, title);
        }
    }

    public void beginSection(int offset, int declarationLength, String title) throws ParseException {
        this.increaseImbricationLevel();
        if (this.currentState == null) {
            this.currentRoot = IntentDocumentFactory.eINSTANCE.createIntentSection();
            this.roots.add(this.currentRoot);
            this.currentState = new SSection(offset, declarationLength, null, (IntentSection)this.currentRoot, this.positionManager, title, this.rootCompleteLevel);
        } else {
            this.currentState = this.currentState.beginSection(offset, declarationLength, title);
        }
    }

    public void endStructuredElement(int offset) throws ParseException {
        if (this.currentImbricationLevel == 0) {
            throw new ParseException("There is no element to close.", offset - 1, 1);
        }
        if (this.currentState != null) {
            this.currentState = this.currentState.endStructuredElement(offset);
            this.decreaseImbricationLevel();
        } else {
            this.addStatusOnElement(this.getRoot(), "Syntax Error on token \"{\" : no element to close.");
        }
    }

    public void addStatusOnElement(EObject element, String statusMessage) {
        if (element instanceof IntentGenericElement) {
            CompilationStatus compilationStatus = CompilerFactory.eINSTANCE.createCompilationStatus();
            compilationStatus.setMessage(statusMessage);
            compilationStatus.setSeverity(CompilationStatusSeverity.ERROR);
            compilationStatus.setTarget((IntentGenericElement)element);
            compilationStatus.setType(CompilationMessageType.INVALID_REFERENCE_ERROR);
            ((IntentGenericElement)element).getCompilationStatus().add((Object)compilationStatus);
        }
    }

    public void modelingUnitContent(int offset, String modelingUnitContent) throws ParseException {
        this.currentState = this.currentState.modelingUnitContent(offset, modelingUnitContent.length(), modelingUnitContent);
    }

    public void descriptionUnitContent(int offset, String descriptionUnitContent) throws ParseException {
        this.currentState = this.currentState.descriptionUnitContent(offset, descriptionUnitContent.length(), this.formatUsingImbricationLevel(descriptionUnitContent, false));
    }

    private String formatUsingImbricationLevel(String content, boolean isModelingUnit) {
        StringBuilder intentContent = new StringBuilder();
        String[] lines = content.split("\n");
        int temporaryIncrease = 0;
        if (isModelingUnit) {
            ++temporaryIncrease;
        }
        int i = 0;
        while (i < lines.length) {
            String currentLine = lines[i];
            currentLine = this.removeBeginningSpaces(currentLine);
            int j = 0;
            while (j < this.currentImbricationLevel + temporaryIncrease) {
                if (currentLine.indexOf("\t") == 0) {
                    currentLine = currentLine.replaceFirst("\t", "");
                }
                ++j;
            }
            intentContent.append(String.valueOf(currentLine) + "\n");
            ++i;
        }
        return intentContent.toString();
    }

    private String removeBeginningSpaces(String line) {
        if (line != null && line.length() > 0) {
            int offset = 0;
            while (offset < line.length() && line.charAt(offset) == ' ') {
                ++offset;
            }
            return line.substring(offset);
        }
        return "";
    }
}

