/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.serializer.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentSectionVisibility;
import org.eclipse.mylyn.docs.intent.serializer.descriptionunit.DescriptionUnitSerializer;
import org.eclipse.mylyn.docs.intent.serializer.internal.IntentElementSerializer;

public final class IntentSectionSerializer {
    private IntentSectionSerializer() {
    }

    public static String serialize(IntentSection section, IntentElementSerializer serializer) {
        StringBuilder renderedForm = new StringBuilder();
        renderedForm.append(serializer.tabulation());
        int initalOffset = serializer.getCurrentOffset();
        if (!section.getVisibility().equals((Object)IntentSectionVisibility.PUBLIC)) {
            renderedForm.append(String.valueOf(section.getVisibility().getLiteral().toLowerCase()) + " ");
        }
        renderedForm.append("Section");
        int initialLength = renderedForm.length();
        renderedForm.append(" ");
        if (section.getTitle() != null) {
            DescriptionUnitSerializer descriptionUnitSerializer = new DescriptionUnitSerializer();
            renderedForm.append(descriptionUnitSerializer.serializeSectionTitle((EObject)section.getTitle(), initalOffset + renderedForm.length()));
            serializer.getPositionManager().addIntentPositionManagerInformations(descriptionUnitSerializer.getPositionManager());
            renderedForm.append(" ");
        }
        renderedForm.append("{");
        serializer.setCurrentIndendationLevel(serializer.getCurrentIndendationLevel() + 1);
        for (EObject content : section.getIntentContent()) {
            if (content instanceof IntentSection) {
                renderedForm.append("\n");
            }
            serializer.setCurrentOffset(initalOffset + renderedForm.length());
            renderedForm.append(serializer.serialize(content));
        }
        serializer.setCurrentIndendationLevel(serializer.getCurrentIndendationLevel() - 1);
        renderedForm.append(String.valueOf(serializer.tabulation()) + "}" + "\n");
        serializer.setCurrentOffset(initalOffset + renderedForm.length());
        serializer.setPositionForElement((EObject)section, initalOffset, renderedForm.length(), initialLength);
        return renderedForm.toString();
    }
}

