/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.modelingunit.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.docs.intent.collab.common.query.TraceabilityInformationsQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.compare.utils.EMFCompareUtils;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.modelingunit.InstanciationInstruction;
import org.eclipse.mylyn.docs.intent.modelingunit.gen.AbstractModelingUnitGenerator;

public abstract class AbstractModelingUnitUpdater
extends AbstractModelingUnitGenerator {
    protected TraceabilityInformationsQuery query;
    private int lastIndex = -1;
    private Map<EObject, String> referenceNames = new HashMap<EObject, String>();
    private Map<EObject, EObject> match = new HashMap<EObject, EObject>();

    public AbstractModelingUnitUpdater(RepositoryAdapter repositoryAdapter) {
        super(repositoryAdapter);
        this.query = new TraceabilityInformationsQuery(repositoryAdapter);
    }

    protected void includeMatch(Resource compiledResource, Resource workingCopyResource) {
        try {
            for (Match matchElement : EMFCompareUtils.compare((Notifier)compiledResource, (Notifier)workingCopyResource).getMatches()) {
                this.collectAllMatches(matchElement);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void collectAllMatches(Match matchElement) {
        EObject workingCopyObject = matchElement.getRight();
        EObject compiledObject = matchElement.getLeft();
        this.match.put(workingCopyObject, compiledObject);
        for (Match subMatchElement : matchElement.getAllSubmatches()) {
            EObject subWorkingCopyObject = subMatchElement.getRight();
            EObject subCompiledObject = subMatchElement.getLeft();
            this.match.put(subWorkingCopyObject, subCompiledObject);
        }
    }

    protected InstanciationInstruction getExistingInstanciationFor(EObject o) {
        EObject compiledObject = this.match.get(o);
        if (compiledObject != null) {
            return this.query.getInstanciation(compiledObject);
        }
        return this.query.getInstanciation(o);
    }

    protected EObject getGeneratedElement(InstanciationInstruction instanciation) {
        return this.query.getInstance(instanciation);
    }

    protected EObject getWorkingCopyEObject(String uri) {
        if (uri == null) {
            return null;
        }
        return this.resourceSet.getEObject(URI.createURI((String)uri), true);
    }

    public static IntentGenericElement getContainer(IntentGenericElement object, int ... classifierId) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        int[] nArray = classifierId;
        int n = classifierId.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = nArray[n2];
            ids.add(id);
            ++n2;
        }
        IntentGenericElement tmp = object;
        while (tmp != null && !ids.contains(tmp.eClass().getClassifierID())) {
            tmp = tmp.eContainer();
        }
        if (tmp != null && ids.contains(tmp.eClass().getClassifierID())) {
            return tmp;
        }
        return null;
    }

    protected void removeFromContainer(EObject element) {
        EObject container = element.eContainer();
        EcoreUtil.delete((EObject)element);
        if (container != null && container.eContents().isEmpty()) {
            this.removeFromContainer(container);
        }
    }

    protected String getReferenceName(EObject eObject) {
        String res = this.referenceNames.get(eObject);
        if (res == null) {
            if (this.lastIndex < 0) {
                String regex = "REF[0-9]+";
                for (InstanciationInstruction instanciation : this.query.getInstanciations()) {
                    String name = instanciation.getName();
                    if (name == null || !name.matches(regex)) continue;
                    int current = Integer.valueOf(name.substring(3));
                    this.lastIndex = Math.max(this.lastIndex, current);
                }
            }
            ++this.lastIndex;
            res = "REF" + this.lastIndex;
            this.referenceNames.put(eObject, res);
        }
        return res;
    }
}

