/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.docs.intent.collab.common.query.IndexQuery;
import org.eclipse.mylyn.docs.intent.collab.common.repository.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceConfig;
import org.eclipse.mylyn.docs.intent.collab.ide.repository.WorkspaceRepository;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndex;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexEntry;

public class RepositoryContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parentElement) {
        IFile iFileIndex;
        Object[] children = new Object[]{};
        if (parentElement instanceof IProject && (iFileIndex = this.getIFileIndex((IProject)parentElement)) != null) {
            children = this.getChildren(iFileIndex);
        }
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            try {
                Repository repository = IntentRepositoryManager.INSTANCE.getRepository(file.getProject().getName());
                repository.getOrCreateSession();
                RepositoryAdapter repositoryAdapter = repository.createRepositoryAdapter();
                children = new IndexQuery(repositoryAdapter).getOrCreateIntentIndex().getEntries().toArray();
            }
            catch (RepositoryConnectionException repositoryConnectionException) {
            }
            catch (CoreException coreException) {}
        }
        if (parentElement instanceof IntentIndex) {
            children = ((IntentIndex)parentElement).getEntries().toArray();
        }
        if (parentElement instanceof IntentIndexEntry) {
            children = ((IntentIndexEntry)parentElement).getSubEntries().toArray();
        }
        return children;
    }

    private IFile getIFileIndex(IProject project) {
        IFile file;
        IFolder repositoryFolder = project.getFolder(WorkspaceConfig.getRepositoryStandardName());
        if (repositoryFolder.exists() && (file = repositoryFolder.getFile("/IntentIndex." + WorkspaceRepository.getWorkspaceResourceExtension())).exists()) {
            return file;
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IntentIndex || element instanceof IntentIndexEntry || element instanceof IProject) {
            return this.getChildren(element).length > 0;
        }
        return false;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IProject) {
            return this.getChildren(this.getIFileIndex((IProject)inputElement));
        }
        return this.getChildren(inputElement);
    }
}

