/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.cdo.repository;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.docs.intent.collab.cdo.repository.CDOConfig;
import org.eclipse.mylyn.docs.intent.collab.common.repository.contribution.IntentRepositoryManagerContribution;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryStructurer;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryCreator;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryRegistry;

public class IntentCDOBasedRepositoryManagerContribution
implements IntentRepositoryManagerContribution {
    private static final String SLASH = "/";

    public boolean canCreateRepository(String identifier) {
        return identifier.startsWith("cdo://");
    }

    public Repository createRepository(String identifier) throws RepositoryConnectionException {
        String repositoryType = "org.eclipse.mylyn.docs.intent.collab.cdo.repository";
        try {
            RepositoryCreator repositoryCreator = RepositoryRegistry.INSTANCE.getRepositoryCreator(repositoryType);
            RepositoryStructurer repositoryStructurer = RepositoryRegistry.INSTANCE.getRepositoryStructurer(repositoryType);
            if (repositoryCreator == null) {
                throw new RepositoryConnectionException("Cannot instantiate a repository of type:" + repositoryType);
            }
            String identifierWithoutPrefix = identifier.substring("cdo://".length());
            String[] fragments = identifierWithoutPrefix.split(SLASH);
            if (fragments.length >= 2) {
                String repositoryLocation = this.checkRepositoryLocation(fragments[0]);
                String repositoryName = this.checkRepositoryName(fragments[1]);
                CDOConfig config = new CDOConfig(repositoryLocation, repositoryName);
                return repositoryCreator.createRepository((Object)config, repositoryStructurer);
            }
            throw new RepositoryConnectionException("Invalid identifier for Intent repository '" + identifier + "': should be cdo:/REPOSITORY_LOCATION/REPOSITORY_NAME (e.g. cdo:/localhost:2036/repo1)");
        }
        catch (CoreException e) {
            throw new RepositoryConnectionException(e.getMessage());
        }
    }

    private String checkRepositoryName(String repositoryName) throws RepositoryConnectionException {
        if (repositoryName.trim().length() == 0) {
            throw new RepositoryConnectionException("Invalid Intent repositoy name '" + repositoryName + "'");
        }
        return repositoryName;
    }

    private String checkRepositoryLocation(String repositoryLocation) throws RepositoryConnectionException {
        if (repositoryLocation.split(":").length != 2) {
            throw new RepositoryConnectionException("Invalid Intent repositoy location '" + repositoryLocation + "': should be IP_ADRESS:PORT_NUMBER (e.g. 'localhost:2036', '192.1.2.3:1038')");
        }
        return repositoryLocation;
    }

    public String normalizeIdentifier(String identifier) {
        String normalizedIdentifier = identifier;
        if (this.canCreateRepository(normalizedIdentifier)) {
            String identifierWithoutPrefix = identifier.substring("cdo://".length());
            String[] fragments = identifierWithoutPrefix.split(SLASH);
            if (fragments.length == 1) {
                normalizedIdentifier = identifier;
            } else if (fragments.length == 2 && fragments[0].contains(":")) {
                normalizedIdentifier = "cdo://" + fragments[1];
            } else if (fragments.length >= 2) {
                normalizedIdentifier = "cdo://" + fragments[0];
            }
        }
        return normalizedIdentifier;
    }
}

