/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.parser.modelingunit.serializer.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.core.modelingunit.AbstractValue;
import org.eclipse.mylyn.docs.intent.core.modelingunit.AffectationOperator;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;
import org.eclipse.mylyn.docs.intent.parser.modelingunit.serializer.internal.ModelingUnitElementDispatcher;

public final class StructuralFeatureAffectationSerializer {
    private StructuralFeatureAffectationSerializer() {
    }

    public static String render(StructuralFeatureAffectation structuralFeatureAffectation, ModelingUnitElementDispatcher dispatcher) {
        boolean isMultiValued;
        int initialOffset = dispatcher.getCurrentOffset();
        StringBuilder renderedForm = new StringBuilder();
        renderedForm.append(structuralFeatureAffectation.getName());
        int declarationLength = renderedForm.length();
        renderedForm.append(" ");
        String affectationSymbol = "=";
        if (structuralFeatureAffectation.getUsedOperator().equals((Object)AffectationOperator.MULTI_VALUED_AFFECTATION)) {
            affectationSymbol = "+=";
        }
        boolean bl = isMultiValued = structuralFeatureAffectation.getValues().size() > 1;
        if (isMultiValued) {
            renderedForm.append(String.valueOf(affectationSymbol) + " " + "[");
        } else {
            renderedForm.append(affectationSymbol);
        }
        renderedForm.append(" ");
        int nbValues = 0;
        for (AbstractValue value : structuralFeatureAffectation.getValues()) {
            if (nbValues > 0) {
                renderedForm.append(" , ");
            }
            dispatcher.setCurrentOffset(initialOffset + renderedForm.length());
            renderedForm.append((String)dispatcher.doSwitch((EObject)value));
            ++nbValues;
        }
        if (isMultiValued) {
            renderedForm.append(" ]");
        }
        renderedForm.append(";");
        if (structuralFeatureAffectation.isLineBreak()) {
            renderedForm.append("\n");
        }
        dispatcher.getPositionManager().setPositionForInstruction((EObject)structuralFeatureAffectation, initialOffset, renderedForm.length(), declarationLength);
        dispatcher.setCurrentOffset(initialOffset + renderedForm.length());
        return renderedForm.toString();
    }
}

