/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.common.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.docs.intent.collab.common.IntentRepositoryManager;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryStructurer;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryCreator;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryRegistry;

public final class IntentRepositoryManagerImpl
implements IntentRepositoryManager {
    private Map<String, Repository> repositoriesByProject = new HashMap<String, Repository>();
    private boolean lock;

    private Repository createRepository(IProject project) throws RepositoryConnectionException, CoreException {
        Repository repository = null;
        if (project.hasNature("org.eclipse.mylyn.docs.intent.client.ui.ide.intentNature")) {
            String repositoryType = IntentRepositoryManagerImpl.getRepositoryType(project);
            RepositoryCreator repositoryCreator = RepositoryRegistry.INSTANCE.getRepositoryCreator(repositoryType);
            RepositoryStructurer repositoryStructurer = RepositoryRegistry.INSTANCE.getRepositoryStructurer(repositoryType);
            if (repositoryCreator == null) {
                throw new RepositoryConnectionException("Cannot instantiate a repository of type:" + repositoryType);
            }
            repository = repositoryCreator.createRepository((Object)project, repositoryStructurer);
        }
        return repository;
    }

    public synchronized Repository getRepository(String projectName) throws RepositoryConnectionException, CoreException {
        Assert.isTrue((!this.lock ? 1 : 0) != 0);
        this.lock = true;
        Repository repository = null;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project != null && project.isAccessible() && (repository = this.repositoriesByProject.get(project.getName())) == null) {
            repository = this.createRepository(project);
            this.repositoriesByProject.put(project.getName(), repository);
        }
        this.lock = false;
        return repository;
    }

    public synchronized boolean isManagedProject(String projectName) {
        return this.repositoriesByProject.get(projectName) != null;
    }

    private static String getRepositoryType(IProject project) throws CoreException {
        ICommand[] iCommandArray = project.getDescription().getBuildSpec();
        int n = iCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (command.getBuilderName().equals("org.eclipse.mylyn.docs.intent.client.ui.ide.intentBuilder")) {
                return (String)command.getArguments().get("type");
            }
            ++n2;
        }
        return null;
    }

    public synchronized void deleteRepository(String projectName) {
        this.repositoriesByProject.remove(projectName);
    }
}

