/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.navigator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.resources.ProjectExplorer;

public class ProjectExplorerRefreshJob
extends Job {
    public static final String PROJECT_EXPLORER_REFRESH_JOB_NAME = "Refreshing Intent Index";
    private IProject project;

    public ProjectExplorerRefreshJob(IProject project, EObject elementToRefresh) {
        super(PROJECT_EXPLORER_REFRESH_JOB_NAME);
        this.setSystem(true);
        this.project = project;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (this.project.isAccessible() && this.project.getNature("org.eclipse.mylyn.docs.intent.client.ui.ide.intentNature") != null) {
                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow activeWorkbenchWindow = iWorkbenchWindowArray[n2];
                    IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                    IViewReference[] iViewReferenceArray = activePage.getViewReferences();
                    int n3 = iViewReferenceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IViewReference viewRef = iViewReferenceArray[n4];
                        if ("org.eclipse.ui.navigator.ProjectExplorer".equals(viewRef.getId())) {
                            final ProjectExplorer projectExplorer = (ProjectExplorer)viewRef.getView(false);
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    ProjectExplorerRefreshJob.this.refreshProjectExplorer(projectExplorer);
                                }
                            });
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {
            return new Status(4, "org.eclipse.mylyn.docs.intent.client.ui.ide", "Error while refreshing the project explorer view");
        }
        return Status.OK_STATUS;
    }

    private void refreshProjectExplorer(ProjectExplorer projectExplorer) {
        CommonViewer commonViewer = projectExplorer.getCommonViewer();
        if (!commonViewer.getControl().isDisposed()) {
            commonViewer.refresh((Object)this.project, true);
        }
    }
}

