/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.ide.repository;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.docs.intent.client.ui.ide.Activator;
import org.eclipse.mylyn.docs.intent.collab.common.repository.contribution.IntentRepositoryManagerContribution;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryStructurer;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryCreator;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryRegistry;

public class IntentProjectBasedRepositoryManagerContribution
implements IntentRepositoryManagerContribution {
    public boolean canCreateRepository(String identifier) {
        return !identifier.contains("/");
    }

    public Repository createRepository(String repositoryIdentifier) throws RepositoryConnectionException {
        Repository repository = null;
        String identifier = this.normalizeIdentifier(repositoryIdentifier);
        try {
            final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(identifier);
            if (project != null && project.exists() && project.isAccessible()) {
                if (!project.isOpen()) {
                    project.open(null);
                }
                RepositoryCreator repositoryCreator = null;
                String repositoryType = null;
                if (project.hasNature("org.eclipse.mylyn.docs.intent.client.ui.ide.intentNature")) {
                    repositoryType = IntentProjectBasedRepositoryManagerContribution.getRepositoryType(project);
                    repositoryCreator = RepositoryRegistry.INSTANCE.getRepositoryCreator(repositoryType);
                }
                if (repositoryCreator == null) {
                    throw new RepositoryConnectionException("Cannot instantiate a repository of type:" + repositoryType);
                }
                RepositoryStructurer repositoryStructurer = RepositoryRegistry.INSTANCE.getRepositoryStructurer(repositoryType);
                repository = repositoryCreator.createRepository((Object)project, repositoryStructurer);
                Job triggerClientLaunching = new Job("Opening Intent project"){

                    protected IStatus run(IProgressMonitor monitor) {
                        Activator.getDefault().getIntentProjectListener().handleOpenedProject(project);
                        return Status.OK_STATUS;
                    }
                };
                triggerClientLaunching.schedule();
            }
        }
        catch (CoreException e) {
            throw new RepositoryConnectionException(e.getMessage());
        }
        return repository;
    }

    private static String getRepositoryType(IProject project) throws CoreException {
        ICommand[] iCommandArray = project.getDescription().getBuildSpec();
        int n = iCommandArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if ("org.eclipse.mylyn.docs.intent.client.ui.ide.intentBuilder".equals(command.getBuilderName())) {
                return (String)command.getArguments().get("type");
            }
            ++n2;
        }
        return null;
    }

    public String normalizeIdentifier(String identifier) {
        String normalizedIdentifier = identifier;
        if (identifier.startsWith("platform:/resource")) {
            normalizedIdentifier = identifier.toString().replaceFirst("platform:/resource/", "");
            normalizedIdentifier = normalizedIdentifier.split("/")[0];
        }
        return normalizedIdentifier;
    }
}

