/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.internal.quickfix.provider;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.AbstractIntentFix;
import org.eclipse.mylyn.docs.intent.client.ui.editor.quickfix.provider.IntentQuickFixProvider;
import org.eclipse.mylyn.docs.intent.client.ui.internal.quickfix.provider.IntentQuickFixProviderDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntentQuickFixProviderRegistry {
    private static final Map<IntentQuickFixProvider, Collection<IntentQuickFixProviderDescriptor>> EXTENSIONS = Maps.newHashMap();

    private IntentQuickFixProviderRegistry() {
    }

    public static void addExtension(IntentQuickFixProviderDescriptor extensionDescriptor) {
        IntentQuickFixProvider extension = extensionDescriptor.getIntentQuickFixProvider();
        if (EXTENSIONS.get(extension) == null) {
            EXTENSIONS.put(extension, new HashSet());
        }
        EXTENSIONS.get(extension).add(extensionDescriptor);
    }

    public static void clearRegistry() {
        EXTENSIONS.clear();
    }

    public static Collection<IntentQuickFixProviderDescriptor> getRegisteredExtensions() {
        HashSet registeredExtensions = Sets.newHashSet();
        for (Collection<IntentQuickFixProviderDescriptor> extensions : EXTENSIONS.values()) {
            registeredExtensions.addAll(extensions);
        }
        return registeredExtensions;
    }

    public static Collection<AbstractIntentFix> getAppliableIntentFixes(IntentAnnotation intentAnnotation) {
        ArrayList quickFixes = Lists.newArrayList();
        for (Collection<IntentQuickFixProviderDescriptor> extensions : EXTENSIONS.values()) {
            for (IntentQuickFixProviderDescriptor descriptor : extensions) {
                if (!descriptor.getIntentQuickFixProvider().canCreateQuickFix(intentAnnotation)) continue;
                quickFixes.add(descriptor.getIntentQuickFixProvider().createQuickFix(intentAnnotation));
            }
        }
        return quickFixes;
    }

    public static void removeExtension(String extensionClassName) {
        for (IntentQuickFixProviderDescriptor extension : IntentQuickFixProviderRegistry.getRegisteredExtensions()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            EXTENSIONS.get(extension.getIntentQuickFixProvider()).clear();
        }
    }
}

