/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.cdo.notification;

import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.session.CDOSessionInvalidationEvent;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.notification.RepositoryChangeNotificationImpl;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotification;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotificationFactory;

public final class CDORepositoryChangeNotificationFactory
implements RepositoryChangeNotificationFactory {
    public RepositoryChangeNotification createRepositoryChangeNotification(Object specificChangeNotification) {
        RepositoryChangeNotification genericChangeNotification = null;
        if (specificChangeNotification instanceof Notification) {
            genericChangeNotification = CDORepositoryChangeNotificationFactory.createFromEMFNotification((Notification)specificChangeNotification);
        }
        if (specificChangeNotification instanceof CDOSessionInvalidationEvent) {
            genericChangeNotification = CDORepositoryChangeNotificationFactory.createFromCDOInvalidationEvent((CDOSessionInvalidationEvent)specificChangeNotification);
        }
        return genericChangeNotification;
    }

    public static RepositoryChangeNotification createFromEMFNotification(Notification notification) {
        EObject target = (EObject)notification.getNotifier();
        RepositoryChangeNotificationImpl newNotification = new RepositoryChangeNotificationImpl();
        newNotification.getImpactedElements().add(target);
        return newNotification;
    }

    public static RepositoryChangeNotification createFromCDOInvalidationEvent(CDOSessionInvalidationEvent event) {
        RepositoryChangeNotificationImpl newNotification = new RepositoryChangeNotificationImpl();
        for (CDORevisionKey key : event.getChangedObjects()) {
            CDORevisionDelta revisionDelta = (CDORevisionDelta)key;
            for (CDOFeatureDelta delta : revisionDelta.getFeatureDeltas()) {
                switch (delta.getType()) {
                    case SET: {
                        if (event.getLocalTransaction() == null) break;
                        newNotification.getImpactedElements().add(event.getLocalTransaction().getObject(key.getID()));
                        break;
                    }
                }
            }
        }
        return newNotification;
    }
}

