/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.handlers.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.mylyn.docs.intent.collab.handlers.LockMode;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryClient;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryObjectHandler;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.notification.elementList.ElementListNotificator;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.Notificator;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.RepositoryChangeNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryObjectHandler
implements RepositoryObjectHandler {
    private Collection<Notificator> notificators = Sets.newLinkedHashSet();
    private Set<RepositoryClient> subscribedClients = Sets.newLinkedHashSet();
    private RepositoryAdapter repositoryAdapter;

    @Override
    public void stop() {
        for (Notificator notificator : this.notificators) {
            notificator.stop();
        }
    }

    @Override
    public Collection<Notificator> getNotificators() {
        return this.notificators;
    }

    @Override
    public void addNotificator(Notificator newNotificator) {
        this.notificators.add(newNotificator);
        newNotificator.addRepositoryObjectHandler(this);
        if (this.mustAllowChangeSubscriptionPolicyForNotificator()) {
            this.allowChangeSubscriptionPolicy();
        }
    }

    @Override
    public void removeNotificator(Notificator notificator) {
        this.notificators.remove(notificator);
        notificator.removeRepositoryObjectHandler(this);
    }

    private boolean mustAllowChangeSubscriptionPolicyForNotificator() {
        return !Iterables.filter(this.notificators, ElementListNotificator.class).iterator().hasNext();
    }

    private void allowChangeSubscriptionPolicy() {
        if (this.repositoryAdapter != null) {
            this.repositoryAdapter.allowChangeSubscriptionPolicy();
        }
    }

    @Override
    public RepositoryAdapter getRepositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public void setRepositoryAdapter(RepositoryAdapter adapter) {
        this.repositoryAdapter = adapter;
    }

    @Override
    public void addClient(RepositoryClient client) {
        this.subscribedClients.add(client);
    }

    @Override
    public void removeClient(RepositoryClient client) {
        this.subscribedClients.remove(client);
    }

    @Override
    public void lockObjects(List<Object> objectsToLock, LockMode lockMode) {
    }

    @Override
    public void unlockObjects(List<Object> objectsToUnlock) {
    }

    @Override
    public void handleChangeNotification(RepositoryChangeNotification notification) {
        if (!this.subscribedClients.isEmpty()) {
            for (RepositoryClient client : this.subscribedClients) {
                client.handleChangeNotification(notification);
            }
        }
    }
}

